/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

import jsci.maths.Complex;
import jsci.maths.chaos.MandelbrotMap;

public final class JuliaSet {
    public static final Complex RABBIT = new Complex(-0.123, 0.745);
    public static final Complex SAN_MARCO = new Complex(-0.75, 0.0);
    public static final Complex SIEGEL_DISK = new Complex(-0.391, -0.587);
    private final MandelbrotMap mbrot;

    public JuliaSet(Complex c) {
        this.mbrot = new MandelbrotMap(c);
    }

    public int isMember(Complex z, int maxIter) {
        for (int i = 0; i < maxIter; ++i) {
            if (!((z = this.mbrot.map(z)).mod() > 2.0)) continue;
            return i + 1;
        }
        return 0;
    }

    public int isMember(double zRe, double zIm, int maxIter) {
        double cRe = this.mbrot.getConstant().real();
        double cIm = this.mbrot.getConstant().imag();
        for (int i = 0; i < maxIter; ++i) {
            double tmp = 2.0 * zRe * zIm + cIm;
            if (!((zRe = zRe * zRe - zIm * zIm + cRe) * zRe + (zIm = tmp) * zIm > 4.0)) continue;
            return i + 1;
        }
        return 0;
    }
}

