/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.algebras;

import jsci.maths.Complex;
import jsci.maths.algebras.BanachSpace;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.ComplexVector;

public class HilbertSpace
implements BanachSpace {
    private int dim;
    private ComplexVector ZERO;

    public HilbertSpace(int n) {
        this.dim = n;
        this.ZERO = new ComplexVector(this.dim);
    }

    public VectorSpace.Member getVector(Complex[] array) {
        return new ComplexVector(array);
    }

    public int dimension() {
        return this.dim;
    }

    @Override
    public AbelianGroup.Member zero() {
        return this.ZERO;
    }

    @Override
    public boolean isZero(AbelianGroup.Member v) {
        return this.ZERO.equals(v);
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return this.ZERO.equals(a.add(b));
    }

    public static interface Member
    extends BanachSpace.Member {
        public Complex scalarProduct(Member var1);
    }
}

