/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;
import jsci.maths.Complex;
import jsci.maths.NumericalConstants;

public final class FourierMath
extends AbstractMath
implements NumericalConstants {
    private FourierMath() {
    }

    public static Complex[] transform(Complex[] data) {
        int N = data.length;
        if (!FourierMath.isPowerOf2(N)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] arrayRe = new double[N];
        double[] arrayIm = new double[N];
        int numBits = FourierMath.numberOfBitsNeeded(N);
        for (int i = 0; i < N; ++i) {
            int j = FourierMath.reverseBits(i, numBits);
            arrayRe[j] = data[i].real();
            arrayIm[j] = data[i].imag();
        }
        FourierMath.fft(arrayRe, arrayIm, Math.PI * 2);
        Complex[] answer = new Complex[N];
        for (int i = 0; i < N; ++i) {
            answer[i] = new Complex(arrayRe[i], arrayIm[i]);
        }
        return answer;
    }

    public static Complex[] transform(double[] dataReal, double[] dataImag) {
        int N = dataReal.length;
        if (!FourierMath.isPowerOf2(N)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] arrayRe = new double[N];
        double[] arrayIm = new double[N];
        int numBits = FourierMath.numberOfBitsNeeded(N);
        for (int i = 0; i < N; ++i) {
            int j = FourierMath.reverseBits(i, numBits);
            arrayRe[j] = dataReal[i];
            arrayIm[j] = dataImag[i];
        }
        FourierMath.fft(arrayRe, arrayIm, Math.PI * 2);
        Complex[] answer = new Complex[N];
        for (int i = 0; i < N; ++i) {
            answer[i] = new Complex(arrayRe[i], arrayIm[i]);
        }
        return answer;
    }

    public static Complex[] transform(double[] data) {
        int N = data.length;
        if (!FourierMath.isPowerOf2(N)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        double[] arrayRe = new double[N];
        double[] arrayIm = new double[N];
        int numBits = FourierMath.numberOfBitsNeeded(N);
        for (int i = 0; i < N; ++i) {
            int j = FourierMath.reverseBits(i, numBits);
            arrayRe[j] = data[i];
        }
        FourierMath.fft(arrayRe, arrayIm, Math.PI * 2);
        Complex[] answer = new Complex[N];
        for (int i = 0; i < N; ++i) {
            answer[i] = new Complex(arrayRe[i], arrayIm[i]);
        }
        return answer;
    }

    public static Complex[] inverseTransform(Complex[] data) {
        int N = data.length;
        if (!FourierMath.isPowerOf2(N)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] arrayRe = new double[N];
        double[] arrayIm = new double[N];
        int numBits = FourierMath.numberOfBitsNeeded(N);
        for (int i = 0; i < N; ++i) {
            int j = FourierMath.reverseBits(i, numBits);
            arrayRe[j] = data[i].real();
            arrayIm[j] = data[i].imag();
        }
        FourierMath.fft(arrayRe, arrayIm, Math.PI * -2);
        Complex[] answer = new Complex[N];
        double denom = N;
        for (int i = 0; i < N; ++i) {
            answer[i] = new Complex(arrayRe[i] / denom, arrayIm[i] / denom);
        }
        return answer;
    }

    public static Complex[] inverseTransform(double[] dataReal, double[] dataImag) {
        int N = dataReal.length;
        if (!FourierMath.isPowerOf2(N)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] arrayRe = new double[N];
        double[] arrayIm = new double[N];
        int numBits = FourierMath.numberOfBitsNeeded(N);
        for (int i = 0; i < N; ++i) {
            int j = FourierMath.reverseBits(i, numBits);
            arrayRe[j] = dataReal[i];
            arrayIm[j] = dataImag[i];
        }
        FourierMath.fft(arrayRe, arrayIm, Math.PI * -2);
        Complex[] answer = new Complex[N];
        double denom = N;
        for (int i = 0; i < N; ++i) {
            answer[i] = new Complex(arrayRe[i] / denom, arrayIm[i] / denom);
        }
        return answer;
    }

    public static Complex[] inverseTransform(double[] data) {
        int N = data.length;
        if (!FourierMath.isPowerOf2(N)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        double[] arrayRe = new double[N];
        double[] arrayIm = new double[N];
        int numBits = FourierMath.numberOfBitsNeeded(N);
        for (int i = 0; i < N; ++i) {
            int j = FourierMath.reverseBits(i, numBits);
            arrayRe[j] = data[i];
        }
        FourierMath.fft(arrayRe, arrayIm, Math.PI * -2);
        Complex[] answer = new Complex[N];
        double denom = N;
        for (int i = 0; i < N; ++i) {
            answer[i] = new Complex(arrayRe[i] / denom, arrayIm[i] / denom);
        }
        return answer;
    }

    private static void fft(double[] arrayRe, double[] arrayIm, double twoPi) {
        int N = arrayRe.length;
        int blockEnd = 1;
        for (int blockSize = 2; blockSize <= N; blockSize <<= 1) {
            double deltaAngle = twoPi / (double)blockSize;
            double alpha = Math.sin(0.5 * deltaAngle);
            alpha = 2.0 * alpha * alpha;
            double beta = Math.sin(deltaAngle);
            for (int i = 0; i < N; i += blockSize) {
                double angleRe = 1.0;
                double angleIm = 0.0;
                int j = i;
                for (int n = 0; n < blockEnd; ++n) {
                    int k = j + blockEnd;
                    double tmpRe = angleRe * arrayRe[k] - angleIm * arrayIm[k];
                    double tmpIm = angleRe * arrayIm[k] + angleIm * arrayRe[k];
                    arrayRe[k] = arrayRe[j] - tmpRe;
                    arrayIm[k] = arrayIm[j] - tmpIm;
                    int n2 = j;
                    arrayRe[n2] = arrayRe[n2] + tmpRe;
                    int n3 = j++;
                    arrayIm[n3] = arrayIm[n3] + tmpIm;
                    tmpRe = alpha * angleRe + beta * angleIm;
                    tmpIm = alpha * angleIm - beta * angleRe;
                    angleRe -= tmpRe;
                    angleIm -= tmpIm;
                }
            }
            blockEnd = blockSize;
        }
    }

    private static boolean isPowerOf2(int x) {
        int BITS_PER_WORD = 32;
        int i = 1;
        int y = 2;
        while (i < 32) {
            if (x == y) {
                return true;
            }
            ++i;
            y <<= 1;
        }
        return false;
    }

    private static int numberOfBitsNeeded(int pwrOf2) {
        if (pwrOf2 < 2) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while ((pwrOf2 & 1 << i) <= 0) {
            ++i;
        }
        return i;
    }

    private static int reverseBits(int index, int numBits) {
        int rev = 0;
        for (int i = 0; i < numBits; ++i) {
            rev = rev << 1 | index & 1;
            index >>= 1;
        }
        return rev;
    }

    public static Complex[] sort(Complex[] output) {
        Complex[] ret = new Complex[output.length];
        int Nby2 = output.length / 2;
        for (int i = 0; i < Nby2; ++i) {
            ret[Nby2 + i] = output[i];
            ret[i] = output[Nby2 + i];
        }
        return ret;
    }

    public static double[] sort(double[] input) {
        double[] ret = new double[input.length];
        int Nby2 = input.length / 2;
        for (int i = 0; i < Nby2; ++i) {
            ret[Nby2 + i] = input[i];
            ret[i] = input[Nby2 + i];
        }
        return ret;
    }
}

