/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.jdmp.gui.algorithm.AlgorithmGUIObject;
import org.jdmp.gui.module.ModuleGUIObject;
import org.jdmp.gui.module.actions.ModuleActions;
import org.jdmp.gui.sample.SampleGUIObject;
import org.jdmp.gui.sample.actions.SampleActions;
import org.jdmp.gui.variable.VariableGUIObject;
import org.jdmp.gui.variable.actions.VariableActions;
import org.ujmp.core.interfaces.CoreObject;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.interfaces.HasToolTip;
import org.ujmp.gui.util.FrameManager;

public abstract class AbstractListPanel
extends JPanel
implements MouseListener,
KeyListener,
ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = -8449938064172061258L;
    protected JTable jTable = null;
    protected GUIObject object = null;
    protected TableModel dataModel = null;
    protected JScrollPane scrollPane = null;

    public AbstractListPanel() {
        this.setLayout(new GridBagLayout());
        Timer timer = new Timer("AbstractListPanel");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (AbstractListPanel.this.isShowing()) {
                    AbstractListPanel.this.repaint(1000L);
                }
            }
        }, 300L, 300L);
        this.setBorder(BorderFactory.createTitledBorder("Object List"));
        this.jTable = new JTable(this.dataModel){
            private static final long serialVersionUID = -1349144990029853301L;

            @Override
            public String getToolTipText(MouseEvent event) {
                try {
                    Object o;
                    int row = this.rowAtPoint(event.getPoint());
                    if (row < AbstractListPanel.this.jTable.getRowCount() && (o = AbstractListPanel.this.jTable.getValueAt(row, 0)) instanceof HasToolTip) {
                        return ((HasToolTip)o).getToolTipText();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        };
        this.jTable.addMouseListener(this);
        this.jTable.addKeyListener(this);
        this.jTable.getSelectionModel().addListSelectionListener(this);
        this.jTable.setAutoResizeMode(4);
        int rowHeight = UIManager.getInt("Table.rowHeight");
        if (rowHeight < 1) {
            rowHeight = 32;
        }
        this.jTable.setRowHeight(rowHeight);
        this.scrollPane = new JScrollPane(this.jTable);
        this.addMouseListener(this);
        this.add((Component)this.jTable.getTableHeader(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public TitledBorder getBorder() {
        return (TitledBorder)super.getBorder();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this) {
            this.mouseClickedOnObjectList(e);
        } else {
            this.mouseClickedOnObject(e);
        }
    }

    public void mouseClickedOnObjectList(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                List actions = null;
                if (actions == null) break;
                JPopupMenu popup = new JPopupMenu();
                for (JComponent jc : actions) {
                    popup.add(jc);
                }
                popup.show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseClickedOnObject(MouseEvent e) {
        GUIObject otemp = null;
        int selectedRow = this.jTable.getSelectedRow();
        if (selectedRow >= 0) {
            Object o = this.dataModel.getValueAt(selectedRow, 0);
            otemp = o instanceof CoreObject ? ((CoreObject)o).getGUIObject() : (GUIObject)o;
        }
        switch (e.getButton()) {
            case 1: {
                if (e.getClickCount() != 2 || otemp == null) break;
                FrameManager.showFrame(otemp);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                GUIObject o;
                int row = this.jTable.rowAtPoint(e.getPoint());
                this.jTable.setRowSelectionInterval(row, row);
                selectedRow = this.jTable.getSelectedRow();
                Object obj = this.dataModel.getValueAt(selectedRow, 0);
                otemp = obj instanceof CoreObject ? ((CoreObject)obj).getGUIObject() : (GUIObject)obj;
                if (otemp == null || (o = otemp) == null) break;
                JPopupMenu popup = new JPopupMenu();
                List objectActions = null;
                if (!(o instanceof AlgorithmGUIObject)) {
                    if (o instanceof ModuleGUIObject) {
                        objectActions = new ModuleActions(this, (ModuleGUIObject)o);
                    } else if (o instanceof SampleGUIObject) {
                        objectActions = new SampleActions(this, (SampleGUIObject)o);
                    } else if (o instanceof VariableGUIObject) {
                        objectActions = new VariableActions(this, (VariableGUIObject)o);
                    }
                }
                for (JComponent jc : objectActions) {
                    popup.add(jc);
                }
                popup.show(this.jTable, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        try {
            GUIObject o = null;
            int row = this.jTable.getSelectedRow();
            if (row < 0 || row >= this.dataModel.getRowCount() || (o = (GUIObject)this.dataModel.getValueAt(row, 0)) != null) {
                // empty if block
            }
            if (e.getKeyChar() != '\u007f' && e.getKeyChar() != '\u0003') {
                System.out.println("char entered in ObjectListPanel: " + e.getKeyChar());
            }
            if (o instanceof VariableGUIObject) {
                Variable v = ((VariableGUIObject)o).getCoreObject();
                switch (e.getKeyChar()) {
                    case 'g': {
                        break;
                    }
                    case 'u': {
                        break;
                    }
                }
            } else if (o instanceof Algorithm) {
                Algorithm a = (Algorithm)((Object)o);
                switch (e.getKeyChar()) {
                    case 'c': {
                        a.calculate();
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public abstract void updateTitle();

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateTitle();
    }
}

