/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.interpreter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jdmp.core.module.Module;
import org.jdmp.core.script.Result;

public class CommandWindow
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 5931204715283753689L;
    private Module module = null;
    private int endPos = 0;
    private JTextPane textField = null;
    private Document doc = null;

    public CommandWindow(Module m) {
        this.module = m;
        this.textField = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public void setSize(Dimension d) {
                if (d.width < this.getParent().getSize().width) {
                    d.width = this.getParent().getSize().width;
                }
                super.setSize(d);
            }
        };
        this.doc = this.textField.getDocument();
        this.textField.setFont(new Font("Monospaced", 0, 13));
        this.textField.addKeyListener(this);
        this.appendText(">> ");
        this.endPos = this.doc.getLength();
        this.setBorder(BorderFactory.createTitledBorder("Command Window"));
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.textField);
        this.add((Component)scrollPane, "Center");
    }

    public synchronized Result execute(String text) throws Exception {
        Result result = null;
        if (text.endsWith(";")) {
            result = this.module.execute(text);
            if (result.getException() != null) {
                this.appendError("\n" + result);
            }
        } else {
            result = this.module.execute(text + ";");
            if (result != null) {
                if (result.getException() != null) {
                    this.appendError("\n" + result);
                } else {
                    this.appendText("\n" + result);
                }
            }
        }
        this.appendText("\n\n>> ");
        this.endPos = this.doc.getLength();
        this.getParent().getParent().repaint();
        return result;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.filterKeys(e);
        try {
            if (e.getKeyCode() == 10) {
                int line = this.doc.getDefaultRootElement().getElementCount() - 1;
                Element map = this.doc.getDefaultRootElement();
                Element lineElem = map.getElement(line);
                int lineStart = lineElem.getStartOffset();
                int lineCount = map.getElementCount();
                int endOffset = lineElem.getEndOffset();
                int lineEnd = line == lineCount - 1 ? endOffset - 1 : endOffset;
                int length = lineEnd - lineStart;
                String text = this.doc.getText(lineStart + 3, length - 3);
                this.execute(text);
                e.consume();
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void appendError(String s) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.RED);
        this.textField.setCharacterAttributes(aset, false);
        this.textField.replaceSelection(s);
        int len = this.doc.getLength();
        this.textField.setCaretPosition(len);
    }

    public void appendText(String s) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.BLACK);
        this.textField.setCharacterAttributes(aset, false);
        this.textField.replaceSelection(s);
        int len = this.doc.getLength();
        this.textField.setCaretPosition(len);
    }

    public void filterKeys(KeyEvent e) {
        try {
            this.textField.setCaretPosition(this.doc.getLength());
            if (e.getKeyCode() == 38) {
                e.consume();
                return;
            }
            if (this.textField.getCaretPosition() <= this.endPos) {
                if (e.getKeyCode() == 8) {
                    e.consume();
                    return;
                }
                if (e.getKeyCode() == 37) {
                    e.consume();
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

