/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.gui.dataset.actions;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.gui.dataset.DataSetGUIObject;
import org.jdmp.gui.dataset.actions.DataSetAction;

public class HenonDataSetAction
extends DataSetAction {
    private static final long serialVersionUID = 3110361907469109630L;

    public HenonDataSetAction(JComponent c, DataSetGUIObject ds) {
        super(c, ds);
        this.putValue("Name", "Henon DataSet");
        this.putValue("ShortDescription", "Creates a demo DataSet with using a Henon map");
        this.putValue("MnemonicKey", 72);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, 512));
    }

    @Override
    public Object call() {
        int sampleCount = -1;
        while (sampleCount <= 0) {
            String s = JOptionPane.showInputDialog(this.getComponent(), "How many samples should the data set contain", "Henon Map DataSet", 3);
            sampleCount = Integer.parseInt(s);
        }
        int inputLength = -1;
        while (inputLength <= 0) {
            String s = JOptionPane.showInputDialog(this.getComponent(), "How many values are used as input", "Henon Map DataSet", 3);
            inputLength = Integer.parseInt(s);
        }
        int predictionLength = -1;
        while (predictionLength <= 0) {
            String s = JOptionPane.showInputDialog(this.getComponent(), "How many values must be predicted", "Henon Map DataSet", 3);
            predictionLength = Integer.parseInt(s);
        }
        ListDataSet henon = ListDataSet.Factory.HenonMap(sampleCount, inputLength, predictionLength);
        henon.showGUI();
        return henon;
    }
}

