/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.hashing;

import java.util.ArrayList;
import java.util.List;
import org.jdmp.core.algorithm.hashing.AbstractHashing;
import org.jdmp.core.algorithm.hashing.HashRandomProjection;
import org.jdmp.core.dataset.ListDataSet;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class LocalitySensitiveHashing
extends AbstractHashing {
    private static final long serialVersionUID = 4449292116298947107L;
    private final int numberOfAndCombinations;
    private final int numberOfOrCombinations;
    private final int numberOfBits;
    private final HashRandomProjection hashRandomProjections;
    private final List<List<Integer>> permutations = new ArrayList<List<Integer>>();

    public LocalitySensitiveHashing() {
        this(4, 5, 20);
    }

    public LocalitySensitiveHashing(int numberOfBits) {
        this(numberOfBits, 5, 20);
    }

    public LocalitySensitiveHashing(int numberOfBits, int numberOfAndCombinations, int numberOfOrCombinations) {
        this.hashRandomProjections = new HashRandomProjection(numberOfAndCombinations * numberOfOrCombinations);
        this.numberOfAndCombinations = numberOfAndCombinations;
        this.numberOfOrCombinations = numberOfOrCombinations;
        this.numberOfBits = numberOfBits;
    }

    @Override
    public void reset() {
        this.hashRandomProjections.clear();
    }

    @Override
    public void train(ListDataSet dataSet) {
        this.hashRandomProjections.train(dataSet);
        for (int i = 0; i < this.numberOfBits; ++i) {
            this.permutations.add(MathUtil.randPermInt(0, this.numberOfOrCombinations * this.numberOfAndCombinations));
        }
    }

    @Override
    public Matrix hash(Matrix input) {
        DenseMatrix result = Matrix.Factory.zeros(1L, (long)this.numberOfBits);
        Matrix hash = this.hashRandomProjections.hash(input);
        for (int b = 0; b < this.numberOfBits; ++b) {
            int pos = 0;
            boolean or = false;
            for (int i = 0; i < this.numberOfOrCombinations; ++i) {
                ++pos;
                boolean and = true;
                for (int j = 1; j < this.numberOfAndCombinations; ++j) {
                    if (hash.getAsBoolean(0L, this.permutations.get(b).get(pos - 1).intValue()) != hash.getAsBoolean(0L, this.permutations.get(b).get(pos).intValue())) {
                        and = false;
                    }
                    ++pos;
                }
                or |= and;
            }
            result.setAsBoolean(or, 0L, b);
        }
        return result;
    }
}

