/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.compression;

import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.compression.Compressor;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.util.concurrent.PFor;

public abstract class AbstractCompressor
extends AbstractAlgorithm
implements Compressor {
    private static final long serialVersionUID = 870196284002196140L;
    private String inputLabel;

    public AbstractCompressor(String inputLabel) {
        this.inputLabel = inputLabel;
    }

    public AbstractCompressor() {
        this("Input");
    }

    public String getInputLabel() {
        return this.inputLabel;
    }

    public int getFeatureCount(ListDataSet dataSet) {
        return (int)((Sample)dataSet.iterator().next()).getAsMatrix(this.getInputLabel()).toRowVector(Calculation.Ret.NEW).getRowCount();
    }

    public void setInputLabel(String inputLabel) {
        this.inputLabel = inputLabel;
    }

    @Override
    public void compress(final ListDataSet dataSet) {
        new PFor(0, dataSet.size() - 1){

            @Override
            public void step(int i) {
                Sample sample = (Sample)dataSet.get(i);
                AbstractCompressor.this.compress(sample);
            }
        };
    }

    @Override
    public final void compress(Sample sample) {
        Matrix output = this.compress(sample.getAsMatrix(this.getInputLabel()));
        sample.put("Compressed", output);
    }

    @Override
    public void decompress(ListDataSet dataSet) {
        for (Sample sample : dataSet) {
            this.compress(sample);
        }
    }

    @Override
    public final void decompress(Sample sample) {
        Matrix output = this.decompress(sample.getAsMatrix("Compressed"));
        sample.put("Decompressed", output);
    }
}

