/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.classification.mlp;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AlgorithmTwoSources;
import org.jdmp.core.algorithm.classification.mlp.MultiLayerNetwork;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.util.MathUtil;

public class DimmingFunction
extends AlgorithmTwoSources {
    private static final long serialVersionUID = -1391123608571352340L;
    private MultiLayerNetwork.BiasType biasType = null;

    public DimmingFunction(MultiLayerNetwork.BiasType biasType) {
        super(new Variable[0]);
        this.setDescription("target = weight' * contactdeviation");
        this.biasType = biasType;
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix weight = MathUtil.getMatrix(input.get("Source 1"));
        Matrix contactdeviation = MathUtil.getMatrix(input.get("Source 2"));
        Matrix transposedWeight = weight.transpose();
        Matrix target = transposedWeight.mtimes(contactdeviation);
        switch (this.biasType) {
            case SINGLE: {
                target = target.subMatrix(Calculation.Ret.NEW, 0L, 0L, target.getRowCount() - 2L, 0L);
                break;
            }
            case MULTIPLE: {
                target = target.subMatrix(Calculation.Ret.NEW, 0L, 0L, target.getRowCount() / 2L - 1L, 0L);
                break;
            }
        }
        result.put("Target", target);
        return result;
    }
}

