/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.classification;

import org.jdmp.core.algorithm.classification.AbstractClassifier;
import org.jdmp.core.algorithm.classification.Classifier;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.sample.Sample;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;

public class ConstantClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 4554183836593870371L;
    private Matrix prediction = null;
    private long maxClassId = 0L;

    @Override
    public Matrix predictOne(Matrix input) {
        return this.prediction;
    }

    @Override
    public void reset() {
        this.prediction = null;
        this.maxClassId = 0L;
    }

    @Override
    public void trainAll(ListDataSet dataSet) {
        Integer c;
        DefaultMapMatrix<Long, Integer> count = new DefaultMapMatrix<Long, Integer>();
        for (Sample s : dataSet) {
            Matrix m = s.getAsMatrix("Target");
            long target = m.getCoordinatesOfMaximum()[1];
            this.maxClassId = Math.max(this.maxClassId, target);
            c = (Integer)count.get(target);
            if (c == null) {
                c = 0;
            }
            Integer n = c;
            Integer n2 = c = Integer.valueOf(c + 1);
            count.put(target, c);
        }
        int max = 0;
        long pc = 0L;
        for (Long t : count.keySet()) {
            c = (Integer)count.get(t);
            if (c <= max) continue;
            max = c;
            pc = t;
        }
        this.prediction = Matrix.Factory.zeros(1L, this.maxClassId + 1L);
        this.prediction.setAsDouble(1.0, 0L, pc);
    }

    @Override
    public Classifier emptyCopy() {
        return new ConstantClassifier();
    }
}

