/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class Seed
extends AbstractAlgorithm {
    private static final long serialVersionUID = -3548797710763315844L;
    public static final String DESCRIPTION = "sets or gets the random seed";

    public Seed(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object o = input.get("Source");
        if (o != null) {
            MathUtil.setSeed(MathUtil.getLong(o));
        }
        result.put("Target", Matrix.Factory.randomSeed());
        return result;
    }
}

