/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.util.MathUtil;

public class Mean
extends AbstractAlgorithm {
    private static final long serialVersionUID = 5594989536534719762L;
    public static final String DESCRIPTION = "target = mean(source)";
    private int defaultDimension = 0;
    private final boolean defaultIgnoreNaN = true;

    public Mean(int dimension) {
        this(new Variable[0]);
        this.defaultDimension = dimension;
    }

    public Mean(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Dimension");
        this.addVariableKey("IgnoreNaN");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Dimension", "Dimension");
        this.setEdgeLabel("IgnoreNaN", "IgnoreNaN");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Dimension", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("IgnoreNaN", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        Object o3;
        int dimension = this.defaultDimension;
        boolean ignoreNaN = true;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix source = MathUtil.getMatrix(input.get("Source"));
        Object o2 = input.get("Dimension");
        if (o2 != null) {
            dimension = MathUtil.getInt(o2);
        }
        if ((o3 = input.get("IgnoreNaN")) != null) {
            ignoreNaN = MathUtil.getBoolean(o3);
        }
        Matrix target = source.mean(Calculation.Ret.NEW, dimension, ignoreNaN);
        result.put("Target", target);
        return result;
    }
}

