/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.dataset.DataSet;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.util.MathUtil;

public class Logisticmap
extends AbstractAlgorithm {
    private static final long serialVersionUID = 5130302022560101472L;
    public static final String DESCRIPTION = "generates a LogisticMap DataSet";
    public static final String SAMPLECOUNT = "SampleCount";
    public static final String INPUTLENGTH = "InputLength";
    public static final String TARGETLENGTH = "TargetLength";

    public Logisticmap(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey(SAMPLECOUNT);
        this.addVariableKey(INPUTLENGTH);
        this.addVariableKey(TARGETLENGTH);
        this.addVariableKey("Target");
        this.setEdgeLabel(SAMPLECOUNT, SAMPLECOUNT);
        this.setEdgeLabel(INPUTLENGTH, INPUTLENGTH);
        this.setEdgeLabel(TARGETLENGTH, TARGETLENGTH);
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection(SAMPLECOUNT, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(INPUTLENGTH, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(TARGETLENGTH, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int sampleCount = MathUtil.getInt(input.get(SAMPLECOUNT));
        sampleCount = sampleCount == 0 ? 100 : sampleCount;
        int inputLength = MathUtil.getInt(input.get(INPUTLENGTH));
        inputLength = inputLength == 0 ? 10 : inputLength;
        int targetLength = MathUtil.getInt(input.get(TARGETLENGTH));
        targetLength = targetLength == 0 ? 5 : targetLength;
        result.put("Target", DataSet.Factory.LogisticMap(sampleCount, inputLength, targetLength));
        return result;
    }
}

