/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.sample.Sample;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class CreateSample
extends AbstractAlgorithm {
    private static final long serialVersionUID = -8708014294068489839L;
    public static final String DESCRIPTION = "creates a sample from data";
    public static final String INPUT = "Input";
    public static final String TARGET = "Target";
    public static final String RESULT = "Result";

    public CreateSample(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey(INPUT);
        this.addVariableKey(TARGET);
        this.addVariableKey(RESULT);
        this.setEdgeLabel(INPUT, INPUT);
        this.setEdgeLabel(TARGET, TARGET);
        this.setEdgeLabel(RESULT, RESULT);
        this.setEdgeDirection(INPUT, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(TARGET, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(RESULT, Algorithm.EdgeDirection.Outgoing);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix in = MathUtil.getMatrix(input.get(INPUT));
        Matrix target = MathUtil.getMatrix(input.get(TARGET));
        Sample s = null;
        if (in == null && target == null) {
            s = Sample.Factory.emptySample();
        } else if (in != null && target == null) {
            s = Sample.Factory.linkToMatrix(in);
        } else if (in != null && target != null) {
            s = Sample.Factory.classificationSample(in, target);
        }
        result.put(RESULT, s);
        return result;
    }
}

