/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class Copy
extends AbstractAlgorithm {
    private static final long serialVersionUID = 4584324844592226070L;
    public static final String DESCRIPTION = "copy an object to clipboard";

    public Copy(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Matrix in = MathUtil.getMatrix(input.get("Source"));
            if (in != null) {
                in.exportTo().clipboard().asDenseCSV();
                result.put("Target", in);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

