/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public class Clone
extends AbstractAlgorithm {
    private static final long serialVersionUID = 4425454677556747249L;
    public static final String DESCRIPTION = "target = source";

    public Clone(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Matrix source = MathUtil.getMatrix(input.get("Source"));
        Matrix target = source.clone();
        result.put("Target", target);
        return result;
    }

    public void setSourceVariable(Variable source) {
        this.setVariable("Source", source);
    }

    public void setTargetVariable(Variable target) {
        this.setVariable("Target", target);
    }
}

