/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdmp.core.AbstractCoreObject;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.util.DefaultObservableMap;
import org.jdmp.core.util.ObservableMap;
import org.jdmp.core.variable.DefaultVariableMap;
import org.jdmp.core.variable.Variable;
import org.jdmp.core.variable.VariableMap;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;

public abstract class AbstractAlgorithm
extends AbstractCoreObject
implements Algorithm {
    private static final long serialVersionUID = 3219035032582720106L;
    private final VariableMap variableMap = new DefaultVariableMap();
    private final ObservableMap<Algorithm> algorithmMap = new DefaultObservableMap<Algorithm>();
    private final ObservableMap<ListDataSet> dataSetMap = new DefaultObservableMap<ListDataSet>();
    private final Map<String, String> edgeLabels = new HashMap<String, String>(2);
    private final Map<String, Algorithm.EdgeDirection> edgeDirections = new HashMap<String, Algorithm.EdgeDirection>(2);
    private final List<String> variableKeys = new ArrayList<String>(2);

    @Override
    public final void setEdgeLabel(String key, String edgeLabel) {
        this.edgeLabels.put(key, edgeLabel);
    }

    @Override
    public final void addVariableKey(String key) {
        this.variableKeys.add(key);
    }

    public final void setVariables(Variable ... variables) {
        for (int i = 0; i < variables.length && i < this.getVariableKeys().size(); ++i) {
            this.variableMap.put(this.variableKeys.get(i), variables[i]);
        }
    }

    @Override
    public final List<String> getVariableKeys() {
        return this.variableKeys;
    }

    @Override
    public final Object getLabelObject() {
        return this.getVariableMap().getAsObject("Label");
    }

    @Override
    public final String getLabel() {
        return this.getVariableMap().getAsString("Label");
    }

    @Override
    public final void setLabel(Object label) {
        this.getVariableMap().setObject("Label", label);
    }

    @Override
    public final String getId() {
        String id = this.getVariableMap().getAsString("Id");
        if (id == null) {
            id = "Algorithm" + this.getCoreObjectId();
            this.setId(id);
        }
        return id;
    }

    @Override
    public final void setId(String id) {
        this.getVariableMap().setObject("Id", id);
    }

    @Override
    public final String getDescription() {
        return this.getVariableMap().getAsString("Description");
    }

    @Override
    public final void setDescription(String description) {
        this.getVariableMap().setObject("Description", description);
    }

    public AbstractAlgorithm() {
        this.setLabel(this.getClass().getSimpleName());
    }

    @Override
    public final void setEdgeDirection(String key, Algorithm.EdgeDirection direction) {
        this.edgeDirections.put(key, direction);
    }

    @Override
    public void setVariable(String index, Variable variable) {
        this.variableMap.put(index, variable);
    }

    @Override
    public final void setAlgorithm(String index, Algorithm a) {
        this.algorithmMap.put(index, a);
    }

    @Override
    public final void clear() {
        if (this.algorithmMap != null) {
            this.algorithmMap.clear();
        }
        if (this.variableMap != null) {
            this.variableMap.clear();
        }
        if (this.dataSetMap != null) {
            this.dataSetMap.clear();
        }
    }

    @Override
    public final Map<String, Object> calculate() {
        HashMap<String, Object> input = new HashMap<String, Object>();
        for (String v : this.getInputKeys()) {
            input.put(v, this.getVariableMap().getMatrix(v));
        }
        Map<String, Object> output = this.calculateObjects(input);
        for (String v : this.getOutputKeys()) {
            this.getVariableMap().setMatrix(v, MathUtil.getMatrix(output.get(v)));
        }
        return output;
    }

    @Override
    public final List<String> getInputKeys() {
        ArrayList<String> inputKeys = new ArrayList<String>();
        for (String v : this.getVariableKeys()) {
            if (!Algorithm.EdgeDirection.Incoming.equals((Object)this.getEdgeDirection(v)) && !Algorithm.EdgeDirection.Bidirectional.equals((Object)this.getEdgeDirection(v))) continue;
            inputKeys.add(v);
        }
        return inputKeys;
    }

    @Override
    public final List<String> getOutputKeys() {
        ArrayList<String> outputKeys = new ArrayList<String>();
        for (String v : this.getVariableKeys()) {
            if (!Algorithm.EdgeDirection.Outgoing.equals((Object)this.getEdgeDirection(v)) && !Algorithm.EdgeDirection.Bidirectional.equals((Object)this.getEdgeDirection(v))) continue;
            outputKeys.add(v);
        }
        return outputKeys;
    }

    @Override
    public final Map<String, Object> calculate(Matrix ... input) {
        return this.calculate(Arrays.asList(input));
    }

    @Override
    public final Map<String, Object> calculateObjects(Object ... input) {
        return this.calculateObjects(Arrays.asList(input));
    }

    @Override
    public final Map<String, Object> calculate(double ... input) {
        LinkedList<Matrix> inputA = new LinkedList<Matrix>();
        for (int i = 0; i < input.length; ++i) {
            inputA.add(Matrix.Factory.linkToValue(input[i]));
        }
        return this.calculate(inputA);
    }

    @Override
    public final Map<String, Object> calculate(List<Matrix> matrices) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> keys = this.getInputKeys();
        for (int i = 0; i < matrices.size(); ++i) {
            String key = keys.get(i);
            map.put(key, matrices.get(i));
        }
        return this.calculateObjects(map);
    }

    @Override
    public final Map<String, Object> calculateObjects(List<Object> matrices) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> keys = this.getInputKeys();
        for (int i = 0; i < matrices.size(); ++i) {
            String key = keys.get(i);
            map.put(key, matrices.get(i));
        }
        return this.calculateObjects(map);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> objects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    @Override
    public final Algorithm.EdgeDirection getEdgeDirection(String key) {
        return this.edgeDirections.get(key);
    }

    @Override
    public final VariableMap getVariableMap() {
        return this.variableMap;
    }

    @Override
    public final ObservableMap<Algorithm> getAlgorithmMap() {
        return this.algorithmMap;
    }

    @Override
    public final ObservableMap<ListDataSet> getDataSetMap() {
        return this.dataSetMap;
    }

    @Override
    public final String getEdgeLabel(String key) {
        return this.edgeLabels.get(key);
    }

    @Override
    public final String toString() {
        if (this.getLabel() == null) {
            return this.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName() + " [" + this.getLabel() + "]";
    }
}

