/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core;

import java.lang.reflect.Constructor;
import javax.swing.JFrame;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.dataset.ListDataSet;
import org.jdmp.core.module.Module;
import org.jdmp.core.sample.Sample;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.interfaces.CoreObject;
import org.ujmp.core.interfaces.GUIObject;
import org.ujmp.core.util.SerializationUtil;

public abstract class AbstractCoreObject
implements CoreObject {
    private static final long serialVersionUID = -4626483429334570721L;
    public static final int X = 1;
    public static final int Y = 0;
    public static final int Z = 2;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    public static final int ALL = Integer.MAX_VALUE;
    protected transient GUIObject guiObject = null;
    private static long runningId = 0L;
    private long coreObjectId = runningId++;

    @Override
    public final long getCoreObjectId() {
        return this.coreObjectId;
    }

    @Override
    public final JFrame showGUI() {
        JFrame frame = this.getGUIObject().getFrame();
        frame.setVisible(true);
        return frame;
    }

    public abstract String toString();

    @Override
    public final void fireValueChanged() {
        if (this.guiObject != null) {
            this.guiObject.fireValueChanged();
        }
    }

    @Override
    public GUIObject getGUIObject() {
        if (this.guiObject == null) {
            try {
                Constructor<?> con = null;
                if (this instanceof Module) {
                    Class<?> c = Class.forName("org.jdmp.gui.module.ModuleGUIObject");
                    con = c.getConstructor(Module.class);
                } else if (this instanceof Variable) {
                    Class<?> c = Class.forName("org.jdmp.gui.variable.VariableGUIObject");
                    con = c.getConstructor(Variable.class);
                } else if (this instanceof Sample) {
                    Class<?> c = Class.forName("org.jdmp.gui.sample.SampleGUIObject");
                    con = c.getConstructor(Sample.class);
                } else if (this instanceof ListDataSet) {
                    Class<?> c = Class.forName("org.jdmp.gui.dataset.DataSetGUIObject");
                    con = c.getConstructor(ListDataSet.class);
                } else if (this instanceof Algorithm) {
                    Class<?> c = Class.forName("org.jdmp.gui.algorithm.AlgorithmGUIObject");
                    con = c.getConstructor(Algorithm.class);
                } else {
                    System.err.println("unknown object type: " + this.getClass());
                }
                this.guiObject = (GUIObject)con.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.guiObject;
    }

    @Override
    public CoreObject clone() {
        try {
            return (CoreObject)SerializationUtil.deserialize(SerializationUtil.serialize(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            runningId = 31L * System.nanoTime() + System.currentTimeMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

