/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.undo;

import java.awt.Component;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.freehep.swing.undo.AbstractDoableEdit;
import org.freehep.swing.undo.LinkableEdit;

public abstract class AnimatedEdit
extends AbstractDoableEdit
implements LinkableEdit {
    private static Logger logger = Logger.getLogger(AnimatedEdit.class.getPackage().getName());
    private int frames;
    private LinkableEdit parent;
    private LinkableEdit nextEdit;
    private LinkableEdit previousEdit;

    public AnimatedEdit(int frames) {
        this.frames = frames;
    }

    @Override
    public LinkableEdit getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LinkableEdit parent) {
        assert (this.parent == null) : "parent can only be set once";
        this.parent = parent;
    }

    @Override
    public LinkableEdit getNextEdit() {
        return this.nextEdit;
    }

    @Override
    public LinkableEdit getPreviousEdit() {
        return this.previousEdit;
    }

    @Override
    public void setNextEdit(LinkableEdit edit) {
        assert (this.nextEdit == null || edit == null) : "trying to set next while already set";
        this.nextEdit = edit;
    }

    @Override
    public void setPreviousEdit(LinkableEdit edit) {
        assert (this.previousEdit == null || edit == null) : "trying to set previous while already set";
        this.previousEdit = edit;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        logger.fine(this.toString());
        if (this.frames > 0) {
            new TimedEdit(true);
        } else {
            this.redoAndNext();
        }
    }

    private void redoAndNext() throws CannotRedoException {
        this.redoEdit();
        LinkableEdit current = this;
        do {
            LinkableEdit next;
            if ((next = current.getNextEdit()) == null) continue;
            logger.finer("Found next in list: " + next);
            next.redo();
            return;
        } while ((current = current.getParent()) != null);
        logger.finer("Reached end of list");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        logger.fine(this.toString());
        if (this.frames > 0) {
            new TimedEdit(false);
        } else {
            this.undoAndPrevious();
        }
    }

    private void undoAndPrevious() throws CannotUndoException {
        this.undoEdit();
        LinkableEdit current = this;
        do {
            LinkableEdit previous;
            if ((previous = current.getPreviousEdit()) == null) continue;
            logger.finer("Found previous in list: " + previous);
            previous.undo();
            return;
        } while ((current = current.getParent()) != null);
        logger.finer("Reached start of list");
    }

    public int getFrames() {
        return this.frames;
    }

    @Override
    public String toString() {
        return "AnimatedEdit: (" + this.frames + ")";
    }

    protected abstract void redoEdit();

    protected abstract void undoEdit();

    protected abstract void startAnimation(boolean var1);

    protected abstract void showAnimation(int var1);

    protected abstract void endAnimation();

    public Shape createTransformedShape(Component component, Shape shape) {
        return shape;
    }

    class TimedEdit
    implements ActionListener {
        private boolean redo;
        private Timer timer;
        private int steps;
        private long t0;

        public TimedEdit(boolean redo) {
            this.redo = redo;
            this.t0 = System.currentTimeMillis();
            logger.finer("Animation Starts for " + AnimatedEdit.this.getClass());
            this.timer = new Timer(3, this);
            this.timer.setInitialDelay(0);
            this.timer.start();
            AnimatedEdit.this.startAnimation(redo);
            this.steps = AnimatedEdit.this.frames;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.steps > 0) {
                --this.steps;
                int frameNo = this.redo ? AnimatedEdit.this.frames - 1 - this.steps : this.steps;
                AnimatedEdit.this.showAnimation(frameNo);
            } else {
                AnimatedEdit.this.endAnimation();
                this.timer.stop();
                logger.finer("Animation Ends for " + AnimatedEdit.this.getClass() + " in " + (System.currentTimeMillis() - this.t0) + " ms.");
                if (this.redo) {
                    AnimatedEdit.this.redoAndNext();
                } else {
                    AnimatedEdit.this.undoAndPrevious();
                }
            }
        }
    }
}

