/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class CellOrientatedTable
extends JTable {
    private boolean tryInterfaces;

    public CellOrientatedTable(TableModel dm) {
        this(dm, false);
    }

    public CellOrientatedTable(TableModel dm, boolean tryInterfaces) {
        super(dm);
        this.tryInterfaces = tryInterfaces;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Class<?> c = this.getValueAt(row, column).getClass();
        if (c == null) {
            return null;
        }
        TableCellEditor editor = this.getDefaultEditor(c);
        if (this.tryInterfaces && editor == this.getDefaultEditor(Object.class)) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                TableCellEditor newEditor = this.getDefaultEditor(interfaces[i]);
                if (newEditor == null) continue;
                editor = newEditor;
                break;
            }
        }
        return editor;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Class<?> c = this.getValueAt(row, column).getClass();
        if (c == null) {
            return null;
        }
        TableCellRenderer renderer = this.getDefaultRenderer(c);
        if (this.tryInterfaces && renderer == this.getDefaultRenderer(Object.class)) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                TableCellRenderer newRenderer = this.getDefaultRenderer(interfaces[i]);
                if (newRenderer == null) continue;
                renderer = newRenderer;
                break;
            }
        }
        return renderer;
    }
}

