/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IConstructor;
import org.freehep.rtti.IDestructor;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IPackage;
import org.freehep.rtti.IType;

public class RTTI {
    private Hashtable packages = new Hashtable();

    public IPackage[] getPackages() {
        IPackage[] p = new IPackage[this.packages.size()];
        int i = 0;
        Enumeration e = this.packages.keys();
        while (e.hasMoreElements()) {
            p[i++] = (IPackage)this.packages.get(e.nextElement());
        }
        return p;
    }

    public IPackage getPackage(String packageName) {
        return (IPackage)this.packages.get(packageName);
    }

    public IPackage createPackage(String packageName) {
        return new IPackage(packageName);
    }

    public IClass createClass(String name, boolean isClass, String packageName, Vector packageComments, Vector comments, Vector eocComments, Vector interfaces, Vector constructors, IDestructor destructor, Vector methods, Vector fields) {
        return this.createClass(name, isClass, packageName, packageComments, comments, eocComments, null, interfaces, constructors, destructor, methods, fields);
    }

    public IClass createClass(String name, boolean isClass, String packageName, Vector packageComments, Vector comments, Vector eocComments, Vector templateParameters, Vector interfaces, Vector constructors, IDestructor destructor, Vector methods, Vector fields) {
        Object[] a4;
        Object[] a3;
        Object[] a2;
        Object[] a1;
        Object[] a0;
        if (packageComments == null) {
            packageComments = new Vector();
        }
        if (comments == null) {
            comments = new Vector();
        }
        if (eocComments == null) {
            eocComments = new Vector();
        }
        if (templateParameters == null) {
            a0 = new String[]{};
        } else {
            a0 = new String[templateParameters.size()];
            templateParameters.copyInto(a0);
        }
        if (interfaces == null) {
            a1 = new String[]{};
        } else {
            a1 = new String[interfaces.size()];
            interfaces.copyInto(a1);
        }
        if (constructors == null) {
            a2 = new IConstructor[]{};
        } else {
            a2 = new IConstructor[constructors.size()];
            constructors.copyInto(a2);
        }
        if (methods == null) {
            a3 = new IMethod[]{};
        } else {
            a3 = new IMethod[methods.size()];
            methods.copyInto(a3);
        }
        if (fields == null) {
            a4 = new IField[]{};
        } else {
            a4 = new IField[fields.size()];
            fields.copyInto(a4);
        }
        IPackage p = this.getPackage(packageName);
        if (p == null) {
            p = this.createPackage(packageName);
            this.packages.put(p.getName(), p);
        } else if (p.getClass(name) != null) {
            System.err.println("Warning: Class " + name + " already exists.");
        }
        IClass clazz = new IClass(name, isClass, packageName, packageComments, comments, eocComments, (String[])a0, (String[])a1, (IConstructor[])a2, destructor, (IMethod[])a3, (IField[])a4);
        p.addClass(clazz);
        return clazz;
    }

    public IConstructor createConstructor(String name, Vector comments, Vector parameterTypes, Vector exceptionTypes) {
        Object[] a2;
        Object[] a1;
        if (comments == null) {
            comments = new Vector();
        }
        if (parameterTypes == null) {
            a1 = new INamedType[]{};
        } else {
            a1 = new INamedType[parameterTypes.size()];
            parameterTypes.copyInto(a1);
        }
        if (exceptionTypes == null) {
            a2 = new String[]{};
        } else {
            a2 = new String[exceptionTypes.size()];
            exceptionTypes.copyInto(a2);
        }
        return new IConstructor(name, comments, (INamedType[])a1, (String[])a2);
    }

    public IDestructor createDestructor(String name, Vector comments, Vector exceptionTypes) {
        Object[] a1;
        if (comments == null) {
            comments = new Vector();
        }
        if (exceptionTypes == null) {
            a1 = new String[]{};
        } else {
            a1 = new String[exceptionTypes.size()];
            exceptionTypes.copyInto(a1);
        }
        return new IDestructor(name, comments, (String[])a1);
    }

    public IMethod createMethod(String name, Vector comments, boolean isStatic, IType returnType, boolean isConst, Vector parameterTypes, Vector exceptionTypes) {
        return this.createMethod(name, comments, isStatic, null, returnType, isConst, parameterTypes, exceptionTypes);
    }

    public IMethod createMethod(String name, Vector comments, boolean isStatic, Vector templateParameters, IType returnType, boolean isConst, Vector parameterTypes, Vector exceptionTypes) {
        Object[] a2;
        Object[] a1;
        Object[] a0;
        if (comments == null) {
            comments = new Vector();
        }
        if (templateParameters == null) {
            a0 = new String[]{};
        } else {
            a0 = new String[templateParameters.size()];
            templateParameters.copyInto(a0);
        }
        if (parameterTypes == null) {
            a1 = new INamedType[]{};
        } else {
            a1 = new INamedType[parameterTypes.size()];
            parameterTypes.copyInto(a1);
        }
        if (exceptionTypes == null) {
            a2 = new String[]{};
        } else {
            a2 = new String[exceptionTypes.size()];
            exceptionTypes.copyInto(a2);
        }
        return new IMethod(name, comments, isStatic, (String[])a0, returnType, isConst, (INamedType[])a1, (String[])a2);
    }

    public IField createField(INamedType namedType, Vector comments) {
        if (comments == null) {
            comments = new Vector();
        }
        return new IField(namedType, comments);
    }

    public INamedType createNamedType(String name, IType type, String init) {
        return new INamedType(name, type, init);
    }

    public IType createType(String name, boolean konst, boolean primitive, boolean enumeration, boolean reference, int pointer, int dimension, Vector types) {
        Object[] a2;
        if (types == null) {
            a2 = new IType[]{};
        } else {
            a2 = new IType[types.size()];
            types.copyInto(a2);
        }
        return new IType(name, konst, primitive, enumeration, reference, pointer, dimension, (IType[])a2);
    }

    public IType createType(String name, IType alias, boolean reference, int pointer, int dimension) {
        return new IType(name, alias, reference, pointer, dimension);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String packagePrefix) {
        StringBuffer s = new StringBuffer("Repository RTTI:\n");
        s.append("================\n");
        Enumeration e = this.packages.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            IPackage p = (IPackage)this.packages.get(key);
            s.append(p.toString(packagePrefix));
            s.append("\n");
            s.append("================\n");
        }
        return s.toString();
    }

    public static String[] getComments(Vector comments, String language) {
        Vector<String> result = new Vector<String>();
        for (String comment : comments) {
            if (comment.startsWith("@")) {
                if (!comment.startsWith("@" + language + ":")) continue;
                result.add(comment.substring(1 + language.length() + 1));
                continue;
            }
            if (language != null && language.equals("java") && comment.startsWith("/** @")) {
                result.add("/**");
                continue;
            }
            result.add(comment);
        }
        Object[] r = new String[result.size()];
        result.copyInto(r);
        return r;
    }
}

