/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.rtti;

import java.util.Properties;
import org.apache.bcel.classfile.Utility;

public class IType {
    private String name;
    private boolean primitive;
    private boolean enumeration;
    private boolean konst;
    private IType alias;
    private int pointer;
    private boolean reference;
    private int dimension;
    private IType[] types;

    IType(String name, boolean konst, boolean primitive, boolean enumeration, boolean reference, int pointer, int dimension, IType[] types) {
        this.name = name;
        this.konst = konst;
        this.primitive = primitive;
        this.enumeration = enumeration;
        this.alias = null;
        this.reference = reference;
        this.pointer = pointer;
        this.dimension = dimension;
        this.types = types;
    }

    IType(String name, IType alias, boolean reference, int pointer, int dimension) {
        this.name = name;
        this.primitive = false;
        this.konst = false;
        this.alias = alias;
        this.reference = reference;
        this.pointer = pointer;
        this.dimension = dimension;
    }

    public String getName() {
        return this.alias == null ? this.name : this.alias.getName();
    }

    public boolean isPrimitive() {
        return this.alias == null ? this.primitive : this.alias.isPrimitive();
    }

    public boolean isEnumeration() {
        return this.alias == null ? this.enumeration : this.alias.isEnumeration();
    }

    public boolean isConst() {
        return this.alias == null ? this.konst : this.alias.isConst();
    }

    public boolean isReference() {
        if (this.alias == null) {
            return this.reference;
        }
        return this.alias.isReference();
    }

    public int getPointer() {
        if (this.alias == null) {
            return this.pointer;
        }
        return this.alias.getPointer();
    }

    public int getDimension() {
        return this.alias == null ? this.dimension : this.alias.getDimension() + this.dimension;
    }

    public IType[] getTypes() {
        return this.types;
    }

    public boolean isVoid() {
        return this.getName().equals("void");
    }

    public String getSignature(String packageName, Properties imports) {
        StringBuffer s = new StringBuffer();
        if (this.alias == null) {
            if (this.isPrimitive() || this.isVoid()) {
                s.append(this.getName());
            } else {
                String name = this.getName();
                for (int i = this.getDimension(); i > 0; --i) {
                    name = this.getTypes()[0].getName();
                }
                s.append((name = imports.getProperty(name, null)) != null ? name : packageName + "." + this.getName());
            }
        } else {
            s.append(this.alias.getSignature(packageName, imports));
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            s.append("[]");
        }
        return Utility.getSignature((String)s.toString());
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        if (this.isConst()) {
            s.append("const ");
        }
        if (this.isPrimitive()) {
            s.append("#");
        }
        if (this.isEnumeration()) {
            s.append("enum ");
        }
        s.append(this.getName());
        IType[] types = this.getTypes();
        if (types.length > 0) {
            s.append("<");
            s.append(types[0].toString());
            for (i = 1; i < types.length; ++i) {
                s.append(", ");
                s.append(types[i].toString());
            }
            s.append(">");
        }
        if (this.isReference()) {
            s.append("&");
        }
        for (i = 0; i < this.getPointer(); ++i) {
            s.append("*");
        }
        for (i = 0; i < this.getDimension(); ++i) {
            s.append("[]");
        }
        if (this.alias != null) {
            s.append("{" + this.name + "}");
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof IType) {
            IType other = (IType)o;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (this.getDimension() != other.getDimension()) {
                return false;
            }
            if (this.isReference() != other.isReference()) {
                return false;
            }
            return this.getPointer() == other.getPointer();
        }
        return false;
    }
}

