/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.record.loop.examples;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.TooManyListenersException;
import org.freehep.record.loop.LoopException;
import org.freehep.record.loop.SequentialRecordLoopImpl;
import org.freehep.record.loop.event.RecordAdapter;
import org.freehep.record.loop.event.RecordSuppliedEvent;
import org.freehep.record.source.EndOfSourceException;
import org.freehep.record.source.SequentialRecordSource;

public class EchoStrings
extends RecordAdapter {
    @Override
    public void recordSupplied(RecordSuppliedEvent event) {
        String[] strings = ((StringsData)event.getRecord()).getStrings();
        int finished = strings.length;
        for (int string = 0; finished != string; ++string) {
            System.out.println(strings[string]);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        EchoStrings listener;
        if (0 == args.length) {
            System.err.println("Filename must be specified.");
            return;
        }
        EchoStrings echoStrings = listener = new EchoStrings();
        echoStrings.getClass();
        LineSupplier supplier = echoStrings.new LineSupplier(args[0]);
        SequentialRecordLoopImpl recordLoop = new SequentialRecordLoopImpl(supplier);
        try {
            recordLoop.addRecordListener(listener);
            long count = 1 < args.length ? (long)Integer.parseInt(args[1]) : -1L;
            long processed = recordLoop.loop(count);
            System.out.println("Processed " + processed + " lines.");
        }
        catch (TooManyListenersException e) {
        }
        catch (LoopException e1) {
            System.err.println("Loop failed:\n" + e1.toString());
        }
        catch (IOException e3) {
            System.err.println("An IOException was thrown.");
        }
    }

    public class LineSupplier
    implements SequentialRecordSource {
        private BufferedReader reader;
        private IOException ioException;
        private StringsData currentLine;

        private LineSupplier() {
        }

        public LineSupplier(String filename) throws FileNotFoundException {
            this.reader = new BufferedReader(new FileReader(filename));
        }

        @Override
        public Object getCurrentRecord() throws EndOfSourceException, IOException {
            if (null != this.ioException) {
                throw this.ioException;
            }
            if (null == this.currentLine) {
                throw new EndOfSourceException("No more lines.");
            }
            return this.currentLine;
        }

        @Override
        public long getEstimatedSize() {
            return -1L;
        }

        @Override
        public void next() {
            this.ioException = null;
            this.currentLine = null;
            String line = null;
            try {
                line = this.reader.readLine();
                if (null == line) {
                    return;
                }
            }
            catch (IOException e) {
                this.ioException = e;
                return;
            }
            this.currentLine = new StringsData(new String[]{line.trim()});
        }

        @Override
        public Class getRecordClass() {
            return StringsData.class;
        }

        @Override
        public String getSourceName() {
            return this.getClass().getName();
        }

        @Override
        public void rewind() throws IOException {
            this.reader.reset();
        }

        @Override
        public void releaseRecord(Object record) {
            if (this.currentLine == record) {
                this.currentLine = null;
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public class StringsData {
        private String[] strings;

        private StringsData() {
        }

        public StringsData(String[] strings) {
            this.strings = strings;
        }

        public String[] getStrings() {
            return this.strings;
        }

        public void setStrings(String[] strings) {
            this.strings = strings;
        }
    }
}

