/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.NoCurrentPoint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Unimplemented;

class YShow
extends FontOperator {
    private String text;
    private int index;
    private float[] offset;

    public YShow() {
    }

    public YShow(String t, float[] o) {
        this.text = t;
        this.offset = o;
        this.index = -1;
    }

    @Override
    public boolean execute(OperandStack os) {
        PSGState gs = os.gstate();
        if (this.text == null) {
            if (os.checkType(PSString.class, PSPackedArray.class)) {
                Point2D point = gs.position();
                if (point == null) {
                    YShow.error(os, new NoCurrentPoint());
                    return true;
                }
                float x0 = (float)point.getX();
                float y0 = (float)point.getY();
                float[] o = os.popPackedArray().toFloats();
                String t = os.popString().getValue();
                if (this.text.length() > this.offset.length) {
                    YShow.error(os, new RangeCheck());
                    return true;
                }
                os.execStack().pop();
                os.execStack().push(new YShow(t, o));
                os.gsave();
                double[] cfm = gs.font().getPackedArray("FontMatrix").toDoubles();
                AffineTransform at = new AffineTransform(cfm[0], cfm[1], cfm[2], cfm[3], (double)x0, (double)y0);
                gs.transform(at);
                return false;
            }
            if (os.checkType(PSString.class, PSString.class)) {
                YShow.error(os, new Unimplemented());
                return true;
            }
            YShow.error(os, new TypeCheck());
            return true;
        }
        if (this.index >= 0) {
            os.gstate().translate(0.0, this.offset[this.index]);
        }
        ++this.index;
        if (this.index >= this.text.length()) {
            os.grestore();
            return true;
        }
        char ch = this.text.charAt(this.index);
        this.show(os, ch);
        return false;
    }
}

