/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.freehep.postscript.PSDevice;

public class VirtualDevice
extends PSDevice {
    private Graphics2D imageGraphics = null;
    private Graphics2D graphics;
    private Dimension dimension;
    private AffineTransform device = new AffineTransform();

    public VirtualDevice(Graphics2D graphics, Dimension dimension) {
        this.graphics = graphics;
        this.dimension = dimension;
        this.fireComponentResizedEvent(new ComponentEvent(null, 101));
    }

    @Override
    public double getWidth() {
        return this.dimension.width;
    }

    @Override
    public double getHeight() {
        return this.dimension.height;
    }

    @Override
    public BufferedImage convertToImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        this.imageGraphics = (Graphics2D)image.getGraphics();
        return image;
    }

    @Override
    public Graphics2D getGraphics() {
        if (this.imageGraphics != null) {
            return this.imageGraphics;
        }
        return super.getGraphics();
    }

    @Override
    public AffineTransform getDeviceTransform() {
        return this.device;
    }

    @Override
    public Graphics getDeviceGraphics() {
        return this.graphics;
    }

    @Override
    public void refresh() {
    }
}

