/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PaintingOperator;
import org.freehep.postscript.TypeCheck;

class UStroke
extends PaintingOperator {
    private boolean done;
    private AffineTransform matrix;

    private UStroke(boolean d, AffineTransform m) {
        this.done = d;
        this.matrix = m;
    }

    public UStroke() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (!this.done) {
            if (!os.checkType(PSPackedArray.class)) {
                UStroke.error(os, new TypeCheck());
                return true;
            }
            AffineTransform matrix = null;
            PSPackedArray proc = os.popPackedArray();
            if (proc.size() == 6) {
                try {
                    matrix = new AffineTransform(proc.toDoubles());
                    if (!os.checkType(PSPackedArray.class)) {
                        UStroke.error(os, new TypeCheck());
                        return true;
                    }
                    proc = os.popPackedArray();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            os.gsave();
            os.gstate().newPath();
            os.dictStack().push(os.dictStack().systemDictionary());
            PSPackedArray upath = (PSPackedArray)proc.copy();
            upath.setExecutable();
            os.execStack().pop();
            os.execStack().push(new UStroke(true, matrix));
            os.execStack().push(upath);
            return false;
        }
        os.dictStack().pop();
        if (this.matrix != null) {
            os.gstate().transform(this.matrix);
        }
        os.gstate().stroke();
        os.grestore();
        return true;
    }
}

