/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.InvalidAccess;
import org.freehep.postscript.NameNotFoundException;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSInputFile;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSString;
import org.freehep.postscript.SyntaxError;
import org.freehep.postscript.SyntaxException;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;

class Token
extends GeneralOperator {
    Token() {
    }

    @Override
    public boolean execute(OperandStack os) {
        try {
            if (os.checkType(PSString.class)) {
                PSString string = os.popString();
                PSObject obj = string.token(os.packingMode(), os.dictStack());
                if (obj != null) {
                    os.push(string);
                    os.push(obj);
                    os.push(true);
                } else {
                    os.push(false);
                }
            } else if (os.checkType(PSFile.class)) {
                PSInputFile file = (PSInputFile)os.popFile();
                PSObject obj = file.token(os.packingMode(), os.dictStack());
                if (obj != null) {
                    os.push(obj);
                    os.push(true);
                } else {
                    os.push(false);
                }
            } else {
                Token.error(os, new TypeCheck());
            }
        }
        catch (ClassCastException e) {
            Token.error(os, new InvalidAccess());
        }
        catch (IOException e) {
            Token.error(os, new IOError());
        }
        catch (SyntaxException e) {
            Token.error(os, new SyntaxError());
        }
        catch (NameNotFoundException e) {
            Token.error(os, new Undefined());
        }
        return true;
    }
}

