/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ControlOperator;
import org.freehep.postscript.LoopingContext;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class Repeat
extends ControlOperator
implements LoopingContext {
    private PSPackedArray procedure = null;
    private int limit = 0;
    private int i = 0;

    public Repeat() {
    }

    private Repeat(int n, PSPackedArray p) {
        this.procedure = p;
        this.limit = n;
        this.i = 0;
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.procedure == null) {
            if (!os.checkType(PSInteger.class, PSPackedArray.class)) {
                Repeat.error(os, new TypeCheck());
                return true;
            }
            PSPackedArray p = os.popPackedArray();
            PSInteger n = os.popInteger();
            if (n.getValue() < 0) {
                Repeat.error(os, new RangeCheck());
                return true;
            }
            os.execStack().pop();
            os.execStack().push(new Repeat(n.getValue(), p));
            return false;
        }
        if (this.i < this.limit) {
            os.execStack().push(this.procedure);
            ++this.i;
            return false;
        }
        return true;
    }
}

