/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;

class ReadString
extends FileOperator {
    ReadString() {
        this.operandTypes = new Class[]{PSFile.class, PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSString string = os.popString();
        PSFile file = os.popFile();
        if (string.size() <= 0) {
            ReadString.error(os, new RangeCheck());
        } else {
            try {
                for (int i = 0; i < string.size(); ++i) {
                    int b = file.read();
                    if (b < 0) {
                        os.push(string.subString(0, i));
                        os.push(false);
                        return true;
                    }
                    string.set(i, b & 0xFF);
                }
                os.push(string.subString(0));
                os.push(true);
            }
            catch (IOException e) {
                ReadString.error(os, new IOError());
            }
        }
        return true;
    }
}

