/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.util.Stack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSMark;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;

public class PostScriptStack
extends Stack {
    protected int marker = -1;

    public Object push(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("PostScript Stack cannot contain 'null'");
        }
        if (!(o instanceof PSObject)) {
            throw new IllegalArgumentException("PostScript Stack can only contain PSObjects, not: " + o);
        }
        return super.push(o);
    }

    public Object push(String s) {
        return super.push(new PSName(s));
    }

    public PSObject peekObject() {
        return (PSObject)this.peek();
    }

    public PSObject peekObject(int i) {
        if (i > this.elementCount) {
            return null;
        }
        return (PSObject)this.elementData[this.elementCount - i - 1];
    }

    public Object pop() {
        if (this.elementCount == 0) {
            return null;
        }
        --this.elementCount;
        return this.elementData[this.elementCount];
    }

    public PSObject popObject() {
        return (PSObject)this.pop();
    }

    public int countToMark() {
        int count = 0;
        int i = this.elementCount - 1;
        while (i > 0 && !(this.elementData[i] instanceof PSMark)) {
            --i;
            ++count;
        }
        return this.elementData[i] instanceof PSMark ? count : -1;
    }

    public PSMark popMark() {
        return (PSMark)super.pop();
    }

    public void mark() {
        this.marker = this.elementCount;
        this.setSize(this.marker);
    }

    public void reset() {
        if (this.marker >= 0) {
            this.setSize(this.marker);
            this.marker = -1;
        }
    }

    public void copyInto(PSArray a) {
        for (int i = 0; i < a.size(); ++i) {
            a.set(i, (PSObject)this.elementData[i]);
        }
    }

    public void printStack() {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            System.out.println(i + ": " + this.elementData[i].getClass().getName() + ": " + this.elementData[i].toString());
        }
    }
}

