/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.freehep.postscript.DSC;
import org.freehep.postscript.Dispatcher;
import org.freehep.postscript.IOError;
import org.freehep.postscript.NameLookup;
import org.freehep.postscript.NameNotFoundException;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSComposite;
import org.freehep.postscript.PSDataSource;
import org.freehep.postscript.PSDataTarget;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSTokenizable;
import org.freehep.postscript.Scanner;
import org.freehep.postscript.SyntaxException;

public class PSString
extends PSComposite
implements PSTokenizable,
PSDataSource,
PSDataTarget,
Comparable {
    private char[] value;
    private int start = 0;
    private int length = 0;
    private ByteInputStream in = null;
    private Scanner scanner = null;
    private ByteOutputStream out = null;
    private DSC dsc = null;

    protected PSString(char[] chars, int index, int count, DSC dsc) {
        super("string", true);
        this.value = chars;
        this.start = index;
        this.length = count;
        this.dsc = dsc;
    }

    public PSString(String string) {
        this(string, new DSC());
    }

    public PSString(String string, DSC dsc) {
        this(string.length());
        string.getChars(0, string.length(), this.value, 0);
        this.dsc = dsc;
    }

    public PSString(int n) {
        this(new char[n]);
    }

    public PSString(char[] chars) {
        this(chars, 0, chars.length, new DSC());
    }

    @Override
    public InputStream getInputStream() {
        if (this.in == null) {
            this.in = new ByteInputStream();
        }
        return this.in;
    }

    @Override
    public DSC getDSC() {
        return this.dsc;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            this.in = new ByteInputStream();
        }
        return this.in.read();
    }

    @Override
    public void reset() throws IOException {
        if (this.in == null) {
            this.in = new ByteInputStream();
        }
        this.in.reset();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new ByteOutputStream();
        }
        return this.out;
    }

    @Override
    public void write(int b, boolean secure) throws IOException {
        if (!secure) {
            throw new IOException();
        }
        if (this.out == null) {
            this.out = new ByteOutputStream();
        }
        this.out.write(b);
    }

    @Override
    public PSObject token(boolean packingMode, NameLookup lookup) throws IOException, SyntaxException, NameNotFoundException {
        this.getScanner();
        return this.scanner.nextToken(packingMode, lookup);
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.isLiteral()) {
            os.push(this.clone());
            return true;
        }
        try {
            this.getScanner();
        }
        catch (IOException e) {
            PSString.error(os, new IOError());
        }
        return Dispatcher.dispatch(os, this);
    }

    @Override
    public String getType() {
        return "stringtype";
    }

    public int size() {
        return this.length;
    }

    public char get(int i) {
        return this.value[this.start + i];
    }

    public void set(int i, byte b) {
        this.set(i, (char)b);
    }

    public void set(int i, int b) {
        this.set(i, (char)b);
    }

    public void set(int i, char c) {
        this.value[this.start + i] = c;
    }

    public PSString set(String s) {
        byte[] b = s.getBytes();
        for (int i = 0; i < b.length; ++i) {
            this.set(i, b[i]);
        }
        return this.subString(0, b.length);
    }

    public PSString subString(int index, int count) {
        if (index < 0 || index + count > this.length) {
            return null;
        }
        return new PSString(this.value, index, count, this.dsc);
    }

    public PSString subString(int index) {
        return this.subString(index, this.length - index);
    }

    public int indexOf(PSString s) {
        String string = this.getValue();
        String seek = s.getValue();
        return string.indexOf(seek);
    }

    public int compareTo(Object o) {
        String s1 = this.getValue();
        String s2 = ((PSString)o).getValue();
        return s1.compareTo(s2);
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSString) {
            return this.getValue().equals(((PSString)o).getValue());
        }
        if (o instanceof PSName) {
            return this.getValue().equals(((PSName)o).getValue());
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSString(this.value, this.start, this.length, this.dsc);
    }

    @Override
    public PSObject copy() {
        return new PSString(new String(this.value, this.start, this.length), this.dsc);
    }

    @Override
    public String cvs() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return "(" + this.getValue() + ")";
    }

    public String getValue() {
        return new String(this.value, this.start, this.length);
    }

    private void getScanner() throws IOException {
        if (this.scanner == null) {
            if (this.in == null) {
                this.in = new ByteInputStream();
            }
            this.scanner = new Scanner(this.in, this.dsc);
        }
    }

    class ByteOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
            if (PSString.this.length >= PSString.this.value.length) {
                throw new IOException();
            }
            ((PSString)PSString.this).value[((PSString)PSString.this).length] = (char)(b & 0xFF);
            PSString.this.length++;
        }
    }

    class ByteInputStream
    extends PushbackInputStream {
        private int initStart;
        private int initLength;

        public ByteInputStream() {
            super(null, 1);
            this.initStart = PSString.this.start;
            this.initLength = PSString.this.length;
        }

        @Override
        public int available() throws IOException {
            return PSString.this.length > 0 ? 1 : 0;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public synchronized void mark(int readLimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (PSString.this.length > 0) {
                int b = PSString.this.value[PSString.this.start] & 0xFF;
                PSString.this.start++;
                PSString.this.length--;
                return b;
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            return 1;
        }

        @Override
        public synchronized void reset() throws IOException {
            PSString.this.start = this.initStart;
            PSString.this.length = this.initLength;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= (long)PSString.this.length) {
                PSString.this.start = (int)((long)PSString.this.start + n);
                PSString.this.length = (int)((long)PSString.this.length - n);
                return n;
            }
            return -1L;
        }

        @Override
        public void unread(int b) throws IOException {
            if (PSString.this.start > 0) {
                PSString.this.start--;
                PSString.this.length++;
            }
        }

        @Override
        public void unread(byte[] b) throws IOException {
            this.unread(b, 0, b.length);
        }

        @Override
        public void unread(byte[] b, int off, int len) throws IOException {
            if (len > PSString.this.start) {
                throw new IOException();
            }
            PSString.this.start -= len;
            PSString.this.length += len;
        }
    }
}

