/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSComposite;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSNull;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSOperator;
import org.freehep.postscript.PSReal;

public class PSPackedArray
extends PSComposite {
    protected PSObject[] array;
    protected int start = 0;
    protected int length = 0;
    private int execIndex = -1;

    protected PSPackedArray(String name, PSObject[] a, int index, int count) {
        super(name, true);
        this.array = a;
        this.start = index;
        this.length = count;
        this.access = 2;
    }

    protected PSPackedArray(int n) {
        super("packedarray", true);
        this.array = new PSObject[n];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = new PSNull();
        }
        this.start = 0;
        this.length = n;
        this.access = 2;
    }

    public PSPackedArray(PSObject[] a) {
        super("packedarray", true);
        this.array = a;
        this.start = 0;
        this.length = a.length;
        this.access = 2;
    }

    public PSPackedArray(float[] f) {
        this(f.length);
        for (int i = 0; i < f.length; ++i) {
            this.array[i] = new PSReal(f[i]);
        }
    }

    public PSPackedArray(double[] d) {
        this(d.length);
        for (int i = 0; i < d.length; ++i) {
            this.array[i] = new PSReal(d[i]);
        }
    }

    public PSPackedArray(String[] s) {
        this(s.length);
        for (int i = 0; i < s.length; ++i) {
            this.array[i] = new PSName(s[i], true);
        }
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.isLiteral()) {
            os.push(this);
            return true;
        }
        if (this.execIndex == -1) {
            PSPackedArray copy = (PSPackedArray)this.clone();
            copy.setExecutable();
            copy.execIndex = 0;
            os.execStack().pop();
            os.execStack().push(copy);
            return false;
        }
        if (this.execIndex < this.size()) {
            PSObject obj = this.get(this.execIndex);
            if (obj instanceof PSPackedArray && ((PSPackedArray)obj).isExecutable()) {
                os.push(obj);
            } else {
                os.execStack().push(obj);
            }
            ++this.execIndex;
            return false;
        }
        this.execIndex = -1;
        return true;
    }

    @Override
    public String getType() {
        return "packedarraytype";
    }

    public PSObject get(int i) {
        return this.array[this.start + i];
    }

    public int getInteger(int i) {
        return ((PSInteger)this.array[this.start + i]).getValue();
    }

    public PSName getName(int i) {
        return (PSName)this.array[this.start + i];
    }

    public PSDictionary getDictionary(int i) {
        return (PSDictionary)this.array[this.start + i];
    }

    public void bind(int i, PSOperator op) {
        this.array[this.start + i] = op;
    }

    public int size() {
        return this.length;
    }

    public PSPackedArray subPackedArray(int index, int count) {
        if (index < 0 || index + count > this.length) {
            throw new IllegalArgumentException("Trying to create subPackedArray(" + index + ", " + count + ") with length=" + this.length + ".");
        }
        return new PSPackedArray(this.name, this.array, index, count);
    }

    @Override
    public int hashCode() {
        return this.array.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSPackedArray) {
            return this.array == ((PSPackedArray)o).array;
        }
        return false;
    }

    @Override
    public Object clone() {
        PSPackedArray p = new PSPackedArray(this.name, this.array, this.start, this.length);
        if (this.isExecutable()) {
            p.setExecutable();
        }
        return p;
    }

    @Override
    public PSObject copy() {
        PSPackedArray p = new PSPackedArray(this.toObjects());
        if (this.isExecutable()) {
            p.setExecutable();
        }
        return p;
    }

    public float[] toFloats() {
        float[] f = new float[this.length];
        for (int i = 0; i < this.length; ++i) {
            f[i] = ((PSNumber)this.get(i)).getFloat();
        }
        return f;
    }

    public double[] toDoubles() {
        double[] d = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            d[i] = ((PSNumber)this.get(i)).getDouble();
        }
        return d;
    }

    public PSObject[] toObjects() {
        PSObject[] o = new PSObject[this.length];
        for (int i = 0; i < this.length; ++i) {
            o[i] = this.get(i);
        }
        return o;
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "--" + (this.isExecutable() ? "*" : "") + this.name + " (" + this.start + ".." + (this.start + this.length) + ", " + this.execIndex + ") --";
    }

    @Override
    public String toPrint() {
        StringBuffer s = new StringBuffer();
        s.append(this.isExecutable() ? "{ " : "[ ");
        for (int i = 0; i < this.size(); ++i) {
            s.append(this.get(i).toString());
            s.append(" ");
        }
        s.append(this.isExecutable() ? "}" : "]");
        return s.toString();
    }
}

