/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSSimple;
import org.freehep.postscript.StackUnderflow;
import org.freehep.postscript.TypeCheck;

public abstract class PSOperator
extends PSSimple {
    protected Class[] operandTypes = new Class[0];

    public PSOperator() {
        super("operator", false);
    }

    public String getName() {
        String name = this.getClass().getName();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        return name.toLowerCase();
    }

    @Override
    public boolean checkAndExecute(OperandStack os) {
        os.mark();
        if (this.operandTypes.length > os.size()) {
            PSOperator.error(os, new StackUnderflow());
            return true;
        }
        if (!os.checkType(this.operandTypes)) {
            PSOperator.error(os, new TypeCheck());
            return true;
        }
        return this.execute(os);
    }

    @Override
    public String getType() {
        return "operatortype";
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSOperator) {
            return this.getClass().equals(o.getClass());
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public PSObject copy() {
        return this;
    }

    @Override
    public String cvs() {
        return this.getName();
    }

    @Override
    public String toString() {
        return "//" + this.getName();
    }
}

