/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSReal;
import org.freehep.postscript.RangeException;

public class PSInteger
extends PSNumber {
    private int value;

    public PSInteger(double v) {
        this((int)v);
    }

    public PSInteger(long v) {
        this((int)v);
    }

    public PSInteger(int v) {
        super("integer");
        this.value = v;
    }

    @Override
    public String getType() {
        return "integertype";
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int getInt() throws RangeException {
        return this.getValue();
    }

    public int compareTo(Object o) {
        int i1 = this.getValue();
        if (o instanceof PSReal) {
            double d2 = ((PSReal)o).getValue();
            return (double)i1 > d2 ? 1 : ((double)i1 < d2 ? -1 : 0);
        }
        int i2 = ((PSInteger)o).getValue();
        return i1 > i2 ? 1 : (i1 < i2 ? -1 : 0);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSInteger) {
            return this.value == ((PSInteger)o).getValue();
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSInteger(this.value);
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }
}

