/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.freehep.postscript.DSC;
import org.freehep.postscript.Dispatcher;
import org.freehep.postscript.IOError;
import org.freehep.postscript.NameLookup;
import org.freehep.postscript.NameNotFoundException;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDataSource;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSTokenizable;
import org.freehep.postscript.Scanner;
import org.freehep.postscript.SyntaxException;

public class PSInputFile
extends PSFile
implements PSTokenizable,
PSDataSource {
    protected InputStream in = null;
    protected Scanner scanner = null;
    protected DSC dsc = null;
    private BufferedReader reader;

    protected PSInputFile(String n, boolean f, InputStream i, Scanner s, DSC d) {
        super(n, f);
        this.in = i;
        this.scanner = s;
        this.dsc = d;
    }

    public PSInputFile(InputStream input, DSC dsc) throws IOException {
        super("pipe", true);
        this.init(input, dsc);
    }

    public PSInputFile(String filename) throws FileNotFoundException, IOException {
        this(filename, new DSC());
    }

    public PSInputFile(String filename, DSC dsc) throws FileNotFoundException, IOException {
        super(filename, false);
        InputStream input;
        try {
            URL url = new URL(filename);
            input = url.openStream();
        }
        catch (MalformedURLException e) {
            input = new FileInputStream(filename);
        }
        catch (ZipException e) {
            throw new FileNotFoundException("Archive cannot be found: " + filename);
        }
        if (filename.toLowerCase().endsWith(".gz")) {
            input = new GZIPInputStream(input);
        }
        this.init(input, dsc);
    }

    private void init(InputStream input, DSC dsc) throws IOException {
        if (!this.filter) {
            input = new BufferedInputStream(input);
        }
        this.in = new PushbackInputStream(input);
        this.access = 2;
        this.dsc = dsc;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public DSC getDSC() {
        return this.dsc;
    }

    private void getScanner() throws IOException {
        if (this.scanner == null) {
            if (this.in == null) {
                throw new IOException();
            }
            this.scanner = new Scanner((PushbackInputStream)this.in, this.dsc);
        }
    }

    @Override
    public PSObject token(boolean packingMode, NameLookup lookup) throws IOException, SyntaxException, NameNotFoundException {
        this.getScanner();
        return this.scanner.nextToken(packingMode, lookup);
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.in == null) {
            return true;
        }
        try {
            this.getScanner();
        }
        catch (IOException e) {
            PSInputFile.error(os, new IOError());
            return true;
        }
        return Dispatcher.dispatch(os, this);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            if (!this.filter) {
                this.in.close();
            }
            this.in = null;
            this.scanner = null;
        }
    }

    @Override
    public int read() throws IOException {
        return this.in != null ? this.in.read() : -1;
    }

    @Override
    public String readLine() throws IOException {
        try {
            if (this.in == null) {
                return null;
            }
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.in));
            }
            return this.reader.readLine();
        }
        catch (ClassCastException e) {
            throw new IOException("Cannot readLine");
        }
    }

    @Override
    public int available() throws IOException {
        return this.in != null ? this.in.available() : -1;
    }

    @Override
    public void flush() throws IOException {
        if (this.in != null) {
            int b;
            while ((b = this.in.read()) != -1) {
            }
            if (this.filter) {
                this.close();
            }
        }
    }

    @Override
    public boolean markSupported() {
        return this.in != null ? this.in.markSupported() : false;
    }

    @Override
    public void mark(int readLimit) {
        Thread.dumpStack();
        if (this.in != null) {
            this.in.mark(readLimit);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.in != null) {
            this.in.reset();
        }
    }

    @Override
    public boolean isValid() {
        return this.in != null;
    }

    @Override
    public int hashCode() {
        return this.in.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSInputFile) {
            return this.in == ((PSInputFile)o).in;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PSInputFile(this.filename, this.filter, this.in, this.scanner, this.dsc);
    }

    @Override
    public PSObject copy() {
        if (this.filter) {
            throw new RuntimeException("Filters cannot be copied");
        }
        try {
            return new PSInputFile(this.filename, this.dsc);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find file while copying: " + this.filename);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException for file while copying: " + this.filename);
        }
    }
}

