/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.DSC;
import org.freehep.postscript.DictionaryStack;
import org.freehep.postscript.ExecutableStack;
import org.freehep.postscript.GStateStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSComposite;
import org.freehep.postscript.PSDataSource;
import org.freehep.postscript.PSDataTarget;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSFile;
import org.freehep.postscript.PSFontID;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSMark;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSReal;
import org.freehep.postscript.PSSave;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PostScriptStack;
import org.freehep.postscript.Processor;

public class OperandStack
extends PostScriptStack {
    private Processor processor;
    private PSGState gstate;
    private final boolean secure;
    private boolean packingMode = true;

    public OperandStack(Processor p, PSGState gs, boolean secure) {
        this.processor = p;
        this.gstate = gs;
        this.secure = secure;
    }

    public PSGState gstate() {
        return this.gstate;
    }

    public void gsave() {
        this.gstateStack().push((PSGState)this.gstate.copy());
    }

    public void grestore() {
        this.gstate = this.gstateStack().popGState();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setPackingMode(boolean state) {
        this.packingMode = state;
    }

    public boolean packingMode() {
        return this.packingMode;
    }

    public DictionaryStack dictStack() {
        return this.processor.dictStack();
    }

    public ExecutableStack execStack() {
        return this.processor.execStack();
    }

    public GStateStack gstateStack() {
        return this.processor.gstateStack();
    }

    public DSC getDSC() {
        return this.processor.getDSC();
    }

    public void push(PSObject o) {
        super.push(o);
    }

    public void push(int i) {
        super.push(new PSInteger(i));
    }

    public void push(double d) {
        super.push(new PSReal(d));
    }

    public void push(boolean b) {
        super.push(new PSBoolean(b));
    }

    public PSComposite popComposite() {
        return (PSComposite)super.pop();
    }

    public PSNumber popNumber() {
        return (PSNumber)super.pop();
    }

    public PSInteger popInteger() {
        return (PSInteger)super.pop();
    }

    public PSReal popReal() {
        return (PSReal)super.pop();
    }

    public PSBoolean popBoolean() {
        return (PSBoolean)super.pop();
    }

    public PSName popName() {
        return (PSName)super.pop();
    }

    public PSFontID popFontID() {
        return (PSFontID)super.pop();
    }

    public PSGState popGState() {
        return (PSGState)super.pop();
    }

    public PSArray popArray() {
        return (PSArray)super.pop();
    }

    public PSPackedArray popPackedArray() {
        return (PSPackedArray)super.pop();
    }

    public PSString popString() {
        return (PSString)super.pop();
    }

    public PSDictionary popDictionary() {
        return (PSDictionary)super.pop();
    }

    public PSFile popFile() {
        return (PSFile)super.pop();
    }

    public PSSave popSave() {
        return (PSSave)super.pop();
    }

    public PSDataSource popDataSource() {
        return (PSDataSource)super.pop();
    }

    public PSDataTarget popDataTarget() {
        return (PSDataTarget)super.pop();
    }

    public void exch() {
        Object t = this.elementData[this.elementCount - 1];
        this.elementData[this.elementCount - 1] = this.elementData[this.elementCount - 2];
        this.elementData[this.elementCount - 2] = t;
    }

    public void dup() {
        super.push(((PSObject)this.elementData[this.elementCount - 1]).clone());
    }

    public void copy(int n) {
        int m = this.elementCount - n;
        int j = this.elementCount;
        for (int i = m; i < j; ++i) {
            super.push(((PSObject)this.elementData[i]).clone());
        }
    }

    public void index(int n) {
        if (n > 0) {
            super.push(((PSObject)this.elementData[this.elementCount - n - 1]).clone());
        }
    }

    public void roll(int n, int j) {
        int i;
        if (j < 0) {
            j = n + j;
        }
        if (j == n || j == 0) {
            return;
        }
        Object[] tmp = new Object[j];
        for (i = 0; i < j; ++i) {
            tmp[i] = this.elementData[this.elementCount - j + i];
        }
        for (i = n - j - 1; i >= 0; --i) {
            this.elementData[this.elementCount - n + j + i] = this.elementData[this.elementCount - n + i];
        }
        for (i = 0; i < j; ++i) {
            this.elementData[this.elementCount - n + i] = tmp[i];
        }
    }

    public boolean clearToMark() {
        int i = this.elementCount - 1;
        if (i < 0) {
            return false;
        }
        while (i >= 0 && !(this.elementData[i] instanceof PSMark)) {
            --i;
        }
        if (i < 0) {
            return false;
        }
        this.elementCount = i;
        return true;
    }

    public boolean checkType(Class type) {
        if (this.elementCount < 1) {
            return false;
        }
        return type.isInstance(this.elementData[this.elementCount - 1]);
    }

    public boolean checkType(Class type1, Class type2) {
        if (this.elementCount < 2) {
            return false;
        }
        return type1.isInstance(this.elementData[this.elementCount - 2]) && type2.isInstance(this.elementData[this.elementCount - 1]);
    }

    public boolean checkType(Class type1, Class type2, Class type3) {
        if (this.elementCount < 3) {
            return false;
        }
        return type1.isInstance(this.elementData[this.elementCount - 3]) && type2.isInstance(this.elementData[this.elementCount - 2]) && type3.isInstance(this.elementData[this.elementCount - 1]);
    }

    public boolean checkType(Class type1, Class type2, Class type3, Class type4) {
        if (this.elementCount < 4) {
            return false;
        }
        return type1.isInstance(this.elementData[this.elementCount - 4]) && type2.isInstance(this.elementData[this.elementCount - 3]) && type3.isInstance(this.elementData[this.elementCount - 2]) && type4.isInstance(this.elementData[this.elementCount - 1]);
    }

    public boolean checkType(Class type1, Class type2, Class type3, Class type4, Class type5) {
        if (this.elementCount < 5) {
            return false;
        }
        return type1.isInstance(this.elementData[this.elementCount - 5]) && type2.isInstance(this.elementData[this.elementCount - 4]) && type3.isInstance(this.elementData[this.elementCount - 3]) && type4.isInstance(this.elementData[this.elementCount - 2]) && type5.isInstance(this.elementData[this.elementCount - 1]);
    }

    public boolean checkType(Class[] types) {
        if (this.elementCount < types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isInstance(this.elementData[this.elementCount - types.length + i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void printStack() {
        System.out.println();
        System.out.println("== Top Operand Stack ==");
        super.printStack();
        System.out.println("== Bottom Operand Stack ==");
    }

    @Override
    public String toString() {
        return "OperandStack";
    }
}

