/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.freehep.postscript.IOError;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSDataSource;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PaintingOperator;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;

class ImageOperator
extends PaintingOperator {
    protected boolean imageMask;
    protected int width;
    protected int height;
    protected AffineTransform matrix;
    protected PSPackedArray[] proc;
    protected PSDataSource[] source;
    protected boolean multi;
    protected int bitsPerComponent;
    protected PSPackedArray decode;
    protected boolean interpolate;
    protected final int dataSize = 8;
    protected BufferedImage image;
    protected int pixelBitStride;
    protected int scanlineStride;
    protected int components;
    protected float[] color;
    protected int[] pixels = new int[4];
    protected int x;
    protected int y;
    protected int c;
    protected boolean popString;

    protected ImageOperator() {
    }

    protected ImageOperator(boolean mask, int w, int h, int b, PSPackedArray m, PSObject[] ds, PSPackedArray d, boolean i) {
        this.imageMask = mask;
        this.width = w;
        this.height = h;
        switch (b) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.bitsPerComponent = b;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.matrix = new AffineTransform(m.toDoubles());
        this.multi = ds.length > 1;
        this.proc = new PSPackedArray[ds.length];
        this.source = new PSDataSource[ds.length];
        if (ds[0] instanceof PSPackedArray) {
            for (int k = 0; k < ds.length; ++k) {
                this.proc[k] = (PSPackedArray)ds[k];
            }
        } else if (ds[0] instanceof PSDataSource) {
            for (int k = 0; k < ds.length; ++k) {
                this.source[k] = (PSDataSource)((Object)ds[k]);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.decode = d;
        this.components = this.decode.size() / 2;
        this.color = new float[this.components];
        this.interpolate = i;
        this.image = new BufferedImage(this.width, this.height, 2);
        this.pixelBitStride = this.bitsPerComponent * this.components;
        this.scanlineStride = (int)Math.ceil(this.width * this.pixelBitStride / 8);
        this.popString = false;
        this.c = 0;
        this.y = 0;
        this.x = 0;
    }

    public boolean handleImageParameters(OperandStack os, boolean mask) {
        if (os.checkType(PSDictionary.class)) {
            PSDictionary dict = os.popDictionary();
            try {
                int type = dict.getInteger("ImageType");
                switch (type) {
                    case 1: {
                        PSObject[] ds;
                        int w = dict.getInteger("Width");
                        int h = dict.getInteger("Height");
                        PSPackedArray m = dict.getPackedArray("ImageMatrix");
                        PSObject multi = dict.get("MultipleDataSources");
                        if (multi != null && ((PSBoolean)multi).getValue()) {
                            if (mask) {
                                ImageOperator.error(os, new RangeCheck());
                                return true;
                            }
                            ds = dict.getPackedArray("DataSource").toObjects();
                        } else {
                            ds = new PSObject[]{dict.get("DataSource")};
                        }
                        int b = dict.getInteger("BitsPerComponent");
                        if (mask && b != 1) {
                            ImageOperator.error(os, new RangeCheck());
                            return true;
                        }
                        PSPackedArray d = dict.getPackedArray("Decode");
                        if (!mask && d.size() != os.gstate().getNumberOfColorSpaceComponents() * 2) {
                            ImageOperator.error(os, new RangeCheck());
                            return true;
                        }
                        PSBoolean inter = (PSBoolean)dict.get("Interpolate");
                        boolean i = inter != null ? inter.getValue() : false;
                        ImageOperator imageOperator = new ImageOperator(mask, w, h, b, m, ds, d, i);
                        os.execStack().pop();
                        os.execStack().push(imageOperator);
                        return false;
                    }
                }
                ImageOperator.error(os, new Undefined());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                ImageOperator.error(os, new Undefined());
            }
            catch (IllegalArgumentException e) {
                ImageOperator.error(os, new Undefined());
            }
            return true;
        }
        if (os.checkType(PSInteger.class, PSInteger.class, PSObject.class, PSPackedArray.class, PSObject.class)) {
            PSPackedArray d;
            int b;
            PSObject[] ds = new PSObject[]{os.popObject()};
            PSPackedArray m = os.popPackedArray();
            if (mask) {
                b = 1;
                d = os.popBoolean().getValue() ? new PSPackedArray(new double[]{1.0, 0.0}) : new PSPackedArray(new double[]{0.0, 1.0});
            } else {
                b = os.popInteger().getValue();
                d = new PSPackedArray(new double[]{0.0, 1.0});
            }
            int h = os.popInteger().getValue();
            int w = os.popInteger().getValue();
            try {
                ImageOperator imageOperator = new ImageOperator(mask, w, h, b, m, ds, d, false);
                os.execStack().pop();
                os.execStack().push(imageOperator);
            }
            catch (IllegalArgumentException e) {
                ImageOperator.error(os, new TypeCheck());
                return true;
            }
            catch (ClassCastException e) {
                ImageOperator.error(os, new TypeCheck());
                return true;
            }
            return false;
        }
        ImageOperator.error(os, new TypeCheck());
        return true;
    }

    @Override
    public boolean execute(OperandStack os) {
        boolean eod = false;
        if (this.proc[this.c] != null && this.popString) {
            PSString s;
            if (!os.checkType(PSString.class)) {
                ImageOperator.error(os, new TypeCheck());
            }
            if ((s = os.popString()).size() <= 0) {
                eod = true;
            }
            this.source[this.c] = s;
        }
        int b = -1;
        int[] prevIndex = new int[4];
        for (int i = 0; i < prevIndex.length; ++i) {
            prevIndex[i] = -1;
        }
        try {
            while (this.y < this.height && !eod) {
                while (this.x < this.width && !eod) {
                    float alpha;
                    float[] rgb;
                    while (this.c < this.components && !eod) {
                        int s;
                        int bitnum = this.x * this.pixelBitStride + this.c * this.bitsPerComponent;
                        int index = this.y * this.scanlineStride + bitnum / 8;
                        int shift = 8 - (bitnum & 7) - this.bitsPerComponent;
                        int n = s = this.multi ? this.c : 0;
                        if (index > prevIndex[s]) {
                            prevIndex[s] = index;
                            if (this.proc[s] != null) {
                                int n2 = b = this.source[s] != null ? this.source[s].read() : -1;
                                if (b < 0) {
                                    this.popString = true;
                                    PSPackedArray p = (PSPackedArray)this.proc[s].clone();
                                    os.execStack().push(p);
                                    return false;
                                }
                            } else {
                                b = this.source[s].read();
                                if (b < 0) {
                                    if (this.source[s] instanceof PSString) {
                                        this.source[s].reset();
                                        b = this.source[s].read();
                                    } else {
                                        eod = true;
                                    }
                                }
                            }
                        }
                        int pixel = b >> shift & (1 << this.bitsPerComponent) - 1;
                        float dMin = ((PSNumber)this.decode.get(this.c * 2 + 0)).getFloat();
                        float dMax = ((PSNumber)this.decode.get(this.c * 2 + 1)).getFloat();
                        this.color[this.c] = dMin + (float)pixel * (dMax - dMin) / (float)((1 << this.bitsPerComponent) - 1);
                        ++this.c;
                    }
                    if (this.imageMask) {
                        rgb = PSGState.toRGB(os.gstate().color(), os.gstate().colorSpace());
                        alpha = this.color[0] == 0.0f ? 1.0f : 0.0f;
                    } else {
                        switch (this.components) {
                            case 1: {
                                rgb = PSGState.toRGB(this.color, "DeviceGray");
                                break;
                            }
                            case 3: {
                                rgb = PSGState.toRGB(this.color, "DeviceRGB");
                                break;
                            }
                            case 4: {
                                rgb = PSGState.toRGB(this.color, "DeviceCMYK");
                                break;
                            }
                            default: {
                                System.out.println("length=" + this.components);
                                ImageOperator.error(os, new RangeCheck());
                                return true;
                            }
                        }
                        alpha = 1.0f;
                    }
                    this.pixels[0] = (int)(rgb[0] * 255.0f);
                    this.pixels[1] = (int)(rgb[1] * 255.0f);
                    this.pixels[2] = (int)(rgb[2] * 255.0f);
                    this.pixels[3] = (int)(alpha * 255.0f);
                    this.image.getRaster().setPixel(this.x, this.y, this.pixels);
                    this.c = 0;
                    ++this.x;
                }
                this.x = 0;
                ++this.y;
            }
            os.gstate().image(this.image, this.matrix);
        }
        catch (IOException e) {
            ImageOperator.error(os, new IOError());
        }
        catch (ClassCastException e) {
            ImageOperator.error(os, new TypeCheck());
        }
        return true;
    }
}

