/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ErrorOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSNull;
import org.freehep.postscript.PSObject;

class HandleError
extends ErrorOperator {
    HandleError() {
    }

    @Override
    public boolean execute(OperandStack os) {
        PSDictionary error = os.dictStack().dollarError();
        if (error.get("newerror").equals(new PSBoolean(true))) {
            System.err.print("\n\n%%[Error: ");
            System.err.print(error.get("errorname").toPrint());
            System.err.print("; Offending Command: ");
            System.err.print(error.get("command").toPrint());
            System.err.println("]%%\n");
            if (!error.get("errorinfo").equals(new PSNull())) {
                System.err.print("Error Info: ");
                System.err.println(error.get("errorinfo").toPrint());
                System.err.println();
            }
            if (error.get("recordstacks").equals(new PSBoolean(true))) {
                System.err.println("Operand Stack (bottom..top)");
                System.err.println(error.get("ostack").toPrint());
                System.err.println();
                System.err.println("Execution Stack (bottom..top)");
                System.err.println(error.get("estack").toPrint());
                System.err.println();
                System.err.println("Dictionary Stack (bottom..top)");
                System.err.println(error.get("dstack").toPrint());
                System.err.println();
            }
            error.put("newerror", (PSObject)new PSBoolean(false));
            error.put("errorinfo", (PSObject)new PSNull());
        }
        return true;
    }
}

