/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class GetInterval
extends GeneralOperator {
    GetInterval() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSArray.class, PSInteger.class, PSInteger.class)) {
            PSInteger c = os.popInteger();
            PSInteger i = os.popInteger();
            PSArray a = os.popArray();
            PSArray s = a.subArray(i.getValue(), c.getValue());
            if (s == null) {
                GetInterval.error(os, new RangeCheck());
            } else {
                os.push(s);
            }
        } else if (os.checkType(PSPackedArray.class, PSInteger.class, PSInteger.class)) {
            PSInteger c = os.popInteger();
            PSInteger i = os.popInteger();
            PSPackedArray a = os.popPackedArray();
            PSPackedArray s = a.subPackedArray(i.getValue(), c.getValue());
            if (s == null) {
                GetInterval.error(os, new RangeCheck());
            } else {
                os.push(s);
            }
        } else if (os.checkType(PSString.class, PSInteger.class, PSInteger.class)) {
            PSInteger c = os.popInteger();
            PSInteger i = os.popInteger();
            PSString s = os.popString();
            PSString ss = s.subString(i.getValue(), c.getValue());
            if (ss == null) {
                GetInterval.error(os, new RangeCheck());
            } else {
                os.push(ss);
            }
        } else {
            GetInterval.error(os, new TypeCheck());
        }
        return true;
    }
}

