/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.SortedMap;
import java.util.TreeMap;

public class FontCache {
    private SortedMap fonts = new TreeMap();

    public FontCache() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] font = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < font.length; ++i) {
            this.replace(font[i].getPSName(), new FontEntry(font[i]));
        }
        this.put("Monospaced.plain", new Font("Monospaced", 0, 12));
        this.put("Monospaced.bold", new Font("Monospaced", 1, 12));
        this.put("Monospaced.italic", new Font("Monospaced", 2, 12));
        this.put("Monospaced.bolditalic", new Font("Monospaced", 3, 12));
        this.put("SansSerif.plain", new Font("SansSerif", 0, 12));
        this.put("SansSerif.bold", new Font("SansSerif", 1, 12));
        this.put("SansSerif.italic", new Font("SansSerif", 2, 12));
        this.put("SansSerif.bolditalic", new Font("SansSerif", 3, 12));
        this.put("Serif.plain", new Font("Serif", 0, 12));
        this.put("Serif.bold", new Font("Serif", 1, 12));
        this.put("Serif.italic", new Font("Serif", 2, 12));
        this.put("Serif.bolditalic", new Font("Serif", 3, 12));
    }

    public Font get(String name) {
        FontEntry entry = (FontEntry)this.fonts.get(name);
        if (entry == null) {
            this.replace(name, entry);
            entry = new FontEntry(name, (FontEntry)this.fonts.get("SansSerif.plain"));
        }
        return entry.getFont();
    }

    public void put(Font font) {
        this.put(font.getPSName(), font);
    }

    public void put(String name, Font font) {
        if (this.fonts.get(name) == null) {
            this.replace(name, new FontEntry(font));
        }
    }

    private void replace(String name, FontEntry entry) {
        this.fonts.put(name, entry);
    }

    class FontEntry {
        private String name;
        private Font font;
        private boolean used;
        private boolean replacement;

        public FontEntry(Font font) {
            this.name = font.getPSName();
            this.font = font;
        }

        public FontEntry(String name, FontEntry replacementFont) {
            this.name = name;
            this.font = replacementFont.getFont();
            this.replacement = true;
        }

        public String getName() {
            return this.name;
        }

        public boolean isUsed() {
            return this.used;
        }

        public boolean isReplacement() {
            return this.replacement;
        }

        public Font getFont() {
            this.used = true;
            return this.font;
        }
    }
}

