/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ConfigurationError;
import org.freehep.postscript.DictFull;
import org.freehep.postscript.DictStackOverflow;
import org.freehep.postscript.DictStackUnderflow;
import org.freehep.postscript.ExecStackOverflow;
import org.freehep.postscript.HandleError;
import org.freehep.postscript.IOError;
import org.freehep.postscript.Interrupt;
import org.freehep.postscript.InvalidAccess;
import org.freehep.postscript.InvalidExit;
import org.freehep.postscript.InvalidFileAccess;
import org.freehep.postscript.InvalidFont;
import org.freehep.postscript.InvalidRestore;
import org.freehep.postscript.LimitCheck;
import org.freehep.postscript.NoCurrentPoint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSBoolean;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSOperator;
import org.freehep.postscript.PostScriptStack;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.StackOverflow;
import org.freehep.postscript.StackUnderflow;
import org.freehep.postscript.SyntaxError;
import org.freehep.postscript.Timeout;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.Undefined;
import org.freehep.postscript.UndefinedFileName;
import org.freehep.postscript.UndefinedResource;
import org.freehep.postscript.UndefinedResult;
import org.freehep.postscript.Unimplemented;
import org.freehep.postscript.UnmatchedMark;
import org.freehep.postscript.Unregistered;
import org.freehep.postscript.VMError;

public abstract class ErrorOperator
extends PSOperator {
    public static Class[] operators = new Class[]{ConfigurationError.class, DictFull.class, DictStackOverflow.class, DictStackUnderflow.class, ExecStackOverflow.class, HandleError.class, Interrupt.class, InvalidAccess.class, InvalidExit.class, InvalidFileAccess.class, InvalidFont.class, InvalidRestore.class, IOError.class, LimitCheck.class, NoCurrentPoint.class, RangeCheck.class, StackOverflow.class, StackUnderflow.class, SyntaxError.class, Timeout.class, TypeCheck.class, Undefined.class, UndefinedFileName.class, UndefinedResource.class, UndefinedResult.class, UnmatchedMark.class, Unregistered.class, VMError.class, Unimplemented.class};

    @Override
    public boolean execute(OperandStack os) {
        PSDictionary error = os.dictStack().dollarError();
        error.put("newerror", (PSObject)new PSBoolean(true));
        error.put("errorname", (PSObject)new PSName(this.getName()));
        error.put("command", os.execStack().peekObject(1));
        if (error.get("recordstacks").equals(new PSBoolean(true))) {
            error.put("ostack", (PSObject)ErrorOperator.stackToArray(os));
            error.put("estack", (PSObject)ErrorOperator.stackToArray(os.execStack()));
            error.put("dstack", (PSObject)ErrorOperator.stackToArray(os.dictStack()));
        }
        os.execStack().pop();
        os.execStack().push("stop");
        return false;
    }

    private static PSArray stackToArray(PostScriptStack stack) {
        PSArray array = new PSArray(stack.size());
        stack.copyInto(array);
        return array;
    }
}

