/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.File;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.InvalidFileAccess;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSString;
import org.freehep.postscript.UndefinedFileName;

class DeleteFile
extends FileOperator {
    DeleteFile() {
        this.operandTypes = new Class[]{PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (!os.isSecure()) {
            DeleteFile.error(os, new InvalidFileAccess());
            return true;
        }
        PSString name = os.popString();
        if (name.get(0) == '%') {
            DeleteFile.error(os, new UndefinedFileName());
        } else {
            File file = new File(name.getValue());
            if (!file.delete()) {
                DeleteFile.error(os, new IOError());
            }
        }
        return true;
    }
}

