/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ConversionOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PSUtils;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.UndefinedResult;

class CvR
extends ConversionOperator {
    CvR() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSNumber.class)) {
            PSNumber n = os.popNumber();
            os.push(n.getDouble());
        } else if (os.checkType(PSString.class)) {
            PSString s = os.popString();
            try {
                PSNumber n = PSUtils.parseNumber(s.getValue());
                os.push(n.getDouble());
            }
            catch (NumberFormatException e) {
                CvR.error(os, new UndefinedResult());
            }
        } else {
            CvR.error(os, new TypeCheck());
        }
        return true;
    }
}

