/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GraphicsStateOperator;
import org.freehep.postscript.OperandStack;

class CurrentCMYKColor
extends GraphicsStateOperator {
    private float[] cmyk;
    private float bg;
    private float ucr;

    public CurrentCMYKColor() {
    }

    private CurrentCMYKColor(float[] color) {
        this.cmyk = color;
        this.bg = -1.0f;
        this.ucr = -1.0f;
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.cmyk == null) {
            float[] color = os.gstate().color("DeviceCMYK");
            os.execStack().pop();
            os.execStack().push(new CurrentCMYKColor(color));
            os.push(color[3]);
            os.execStack().push(os.gstate().blackGeneration().copy());
            return false;
        }
        if (this.bg < 0.0f) {
            this.bg = os.popNumber().getFloat();
            os.push(this.cmyk[3]);
            os.execStack().push(os.gstate().underColorRemoval().copy());
            return false;
        }
        this.ucr = os.popNumber().getFloat();
        this.cmyk[0] = Math.min(1.0f, Math.max(0.0f, this.cmyk[0] - this.ucr));
        this.cmyk[1] = Math.min(1.0f, Math.max(0.0f, this.cmyk[1] - this.ucr));
        this.cmyk[2] = Math.min(1.0f, Math.max(0.0f, this.cmyk[2] - this.ucr));
        this.cmyk[3] = Math.min(1.0f, Math.max(0.0f, this.bg));
        for (int i = 0; i < this.cmyk.length; ++i) {
            os.push(this.cmyk[i]);
        }
        return true;
    }
}

