/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ArithmeticOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.UndefinedResult;

class Atan
extends ArithmeticOperator {
    Atan() {
        this.operandTypes = new Class[]{PSNumber.class, PSNumber.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSNumber den = os.popNumber();
        PSNumber num = os.popNumber();
        if (den.getDouble() == 0.0 && num.getDouble() == 0.0) {
            Atan.error(os, new UndefinedResult());
        } else {
            double angle = Math.toDegrees(Math.atan2(num.getDouble(), den.getDouble()));
            os.push(angle);
        }
        return true;
    }
}

