/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.AnalyticalGradientCalculator;
import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FCNGradientBase;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumBuilder;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumSeedGenerator;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserFcn;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.Numerical2PGradientCalculator;

abstract class ModularFunctionMinimizer {
    ModularFunctionMinimizer() {
    }

    FunctionMinimum minimize(FCNBase fcn, MnUserParameterState st, MnStrategy strategy, int maxfcn, double toler, double errorDef, boolean useAnalyticalGradient, boolean checkGradient) {
        MnUserFcn mfcn = new MnUserFcn(fcn, errorDef, st.trafo());
        GradientCalculator gc = fcn instanceof FCNGradientBase && useAnalyticalGradient ? new AnalyticalGradientCalculator((FCNGradientBase)fcn, st.trafo(), checkGradient) : new Numerical2PGradientCalculator(mfcn, st.trafo(), strategy);
        int npar = st.variableParameters();
        if (maxfcn == 0) {
            maxfcn = 200 + 100 * npar + 5 * npar * npar;
        }
        MinimumSeed mnseeds = this.seedGenerator().generate(mfcn, gc, st, strategy);
        return this.minimize(mfcn, gc, mnseeds, strategy, maxfcn, toler);
    }

    abstract MinimumSeedGenerator seedGenerator();

    abstract MinimumBuilder builder();

    FunctionMinimum minimize(MnFcn mfcn, GradientCalculator gc, MinimumSeed seed, MnStrategy strategy, int maxfcn, double toler) {
        return this.builder().minimum(mfcn, gc, seed, strategy, maxfcn, toler * mfcn.errorDef());
    }
}

