/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MnPrint;

public class MnUserCovariance {
    private double[] theData;
    private int theNRow;

    private MnUserCovariance(MnUserCovariance other) {
        this.theData = (double[])other.theData.clone();
        this.theNRow = other.theNRow;
    }

    MnUserCovariance() {
        this.theData = new double[0];
        this.theNRow = 0;
    }

    MnUserCovariance(double[] data, int nrow) {
        if (data.length != nrow * (nrow + 1) / 2) {
            throw new IllegalArgumentException("Inconsistent arguments");
        }
        this.theData = data;
        this.theNRow = nrow;
    }

    protected MnUserCovariance clone() {
        return new MnUserCovariance(this);
    }

    public MnUserCovariance(int nrow) {
        this.theData = new double[nrow * (nrow + 1) / 2];
        this.theNRow = nrow;
    }

    public double get(int row, int col) {
        if (row >= this.theNRow || col >= this.theNRow) {
            throw new IllegalArgumentException();
        }
        if (row > col) {
            return this.theData[col + row * (row + 1) / 2];
        }
        return this.theData[row + col * (col + 1) / 2];
    }

    public void set(int row, int col, double value) {
        if (row >= this.theNRow || col >= this.theNRow) {
            throw new IllegalArgumentException();
        }
        if (row > col) {
            this.theData[col + row * (row + 1) / 2] = value;
        } else {
            this.theData[row + col * (col + 1) / 2] = value;
        }
    }

    void scale(double f) {
        int i = 0;
        while (i < this.theData.length) {
            int n = i++;
            this.theData[n] = this.theData[n] * f;
        }
    }

    double[] data() {
        return this.theData;
    }

    public int nrow() {
        return this.theNRow;
    }

    public int ncol() {
        return this.theNRow;
    }

    int size() {
        return this.theData.length;
    }

    public String toString() {
        return MnPrint.toString(this);
    }
}

