/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.List;
import org.freehep.math.minuit.Point;

public class MnPlot {
    private int thePageWidth;
    private int thePageLength;
    private double bl;
    private double bh;
    private int nb;
    private double bwid;

    public MnPlot() {
        this(80, 30);
    }

    public MnPlot(int width, int length) {
        this.thePageWidth = width;
        this.thePageLength = length;
        if (this.thePageWidth > 120) {
            this.thePageWidth = 120;
        }
        if (this.thePageLength > 56) {
            this.thePageLength = 56;
        }
    }

    public void plot(List<Point> points) {
        double[] x = new double[points.size()];
        double[] y = new double[points.size()];
        StringBuffer chpt = new StringBuffer(points.size());
        int i = 0;
        for (Point ipoint : points) {
            x[i] = ipoint.first;
            y[i] = ipoint.second;
            chpt.append('*');
            ++i;
        }
        this.mnplot(x, y, chpt, points.size(), this.width(), this.length());
    }

    public void plot(double xmin, double ymin, List<Point> points) {
        double[] x = new double[points.size() + 2];
        x[0] = xmin;
        x[1] = xmin;
        double[] y = new double[points.size() + 2];
        y[0] = ymin;
        y[1] = ymin;
        StringBuffer chpt = new StringBuffer(points.size() + 2);
        chpt.append(' ');
        chpt.append('X');
        int i = 2;
        for (Point ipoint : points) {
            x[i] = ipoint.first;
            y[i] = ipoint.second;
            chpt.append('*');
            ++i;
        }
        this.mnplot(x, y, chpt, points.size() + 2, this.width(), this.length());
    }

    int width() {
        return this.thePageWidth;
    }

    int length() {
        return this.thePageLength;
    }

    private void mnplot(double[] xpt, double[] ypt, StringBuffer chpt, int nxypt, int npagwd, int npagln) {
        int ibk;
        double xmax;
        int j;
        int i;
        int maxny;
        int maxnx;
        double[] xvalus = new double[12];
        StringBuffer cline = new StringBuffer(npagwd);
        for (int ii = 0; ii < npagwd; ++ii) {
            cline.append(' ');
        }
        int n = maxnx = npagwd - 20 < 100 ? npagwd - 20 : 100;
        if (maxnx < 10) {
            maxnx = 10;
        }
        if ((maxny = npagln) < 10) {
            maxny = 10;
        }
        if (nxypt <= 1) {
            return;
        }
        double xbest = xpt[0];
        double ybest = ypt[0];
        char chbest = chpt.charAt(0);
        int km1 = nxypt - 1;
        for (i = 1; i <= km1; ++i) {
            boolean iquit = false;
            int ni = nxypt - i;
            for (j = 1; j <= ni; ++j) {
                if (ypt[j - 1] > ypt[j]) continue;
                double savx = xpt[j - 1];
                xpt[j - 1] = xpt[j];
                xpt[j] = savx;
                double savy = ypt[j - 1];
                ypt[j - 1] = ypt[j];
                ypt[j] = savy;
                char chsav = chpt.charAt(j - 1);
                chpt.setCharAt(j - 1, chpt.charAt(j));
                chpt.setCharAt(j, chsav);
                iquit = true;
            }
            if (!iquit) break;
        }
        double xmin = xmax = xpt[0];
        for (i = 1; i <= nxypt; ++i) {
            if (xpt[i - 1] > xmax) {
                xmax = xpt[i - 1];
            }
            if (!(xpt[i - 1] < xmin)) continue;
            xmin = xpt[i - 1];
        }
        double dxx = (xmax - xmin) * 0.001;
        this.mnbins(xmin -= dxx, xmax += dxx, maxnx);
        xmin = this.bl;
        xmax = this.bh;
        int nx = this.nb;
        double bwidx = this.bwid;
        double ymax = ypt[0];
        double ymin = ypt[nxypt - 1];
        if (ymax == ymin) {
            ymax = ymin + 1.0;
        }
        double dyy = (ymax - ymin) * 0.001;
        this.mnbins(ymin -= dyy, ymax += dyy, maxny);
        ymin = this.bl;
        ymax = this.bh;
        int ny = this.nb;
        double bwidy = this.bwid;
        double any = ny;
        if (chbest != ' ') {
            xbest = (xmax + xmin) * 0.5;
            ybest = (ymax + ymin) * 0.5;
        }
        double ax = 1.0 / bwidx;
        double ay = 1.0 / bwidy;
        double bx = -ax * xmin + 2.0;
        double by = -ay * ymin - 2.0;
        for (i = 1; i <= nxypt; ++i) {
            xpt[i - 1] = ax * xpt[i - 1] + bx;
            ypt[i - 1] = any - ay * ypt[i - 1] - by;
        }
        int nxbest = (int)(ax * xbest + bx);
        int nybest = (int)(any - ay * ybest - by);
        ny += 2;
        nx += 2;
        int isp1 = 1;
        boolean linodd = true;
        boolean overpr = false;
        for (i = 1; i <= ny; ++i) {
            for (ibk = 1; ibk <= nx; ++ibk) {
                cline.setCharAt(ibk - 1, ' ');
            }
            cline.setCharAt(0, '.');
            cline.setCharAt(nx - 1, '.');
            cline.setCharAt(nxbest - 1, '.');
            if (i == 1 || i == nybest || i == ny) {
                for (j = 1; j <= nx; ++j) {
                    cline.setCharAt(j - 1, '.');
                }
            }
            double yprt = ymax - ((double)i - 1.0) * bwidy;
            boolean isplset = false;
            if (isp1 <= nxypt) {
                for (int k = isp1; k <= nxypt; ++k) {
                    int ks = (int)ypt[k - 1];
                    if (ks > i) {
                        isp1 = k;
                        isplset = true;
                        break;
                    }
                    int ix = (int)xpt[k - 1];
                    if (cline.charAt(ix - 1) != '.' && cline.charAt(ix - 1) != ' ') {
                        if (cline.charAt(ix - 1) == chpt.charAt(k - 1)) continue;
                        overpr = true;
                        cline.setCharAt(ix - 1, '&');
                        continue;
                    }
                    cline.setCharAt(ix - 1, chpt.charAt(k - 1));
                }
                if (!isplset) {
                    isp1 = nxypt + 1;
                }
            }
            if (!linodd && i != ny) {
                linodd = true;
                System.out.printf("                  %s", cline.substring(0, 60));
            } else {
                System.out.printf(" %14.7g ..%s", yprt, cline.substring(0, 60));
                linodd = false;
            }
            System.out.println();
        }
        for (ibk = 1; ibk <= nx; ++ibk) {
            cline.setCharAt(ibk - 1, ' ');
            if (ibk % 10 != 1) continue;
            cline.setCharAt(ibk - 1, '/');
        }
        System.out.printf("                  %s", cline);
        System.out.printf("\n", new Object[0]);
        for (ibk = 1; ibk <= 12; ++ibk) {
            xvalus[ibk - 1] = xmin + ((double)ibk - 1.0) * 10.0 * bwidx;
        }
        System.out.printf("           ", new Object[0]);
        int iten = (nx + 9) / 10;
        for (ibk = 1; ibk <= iten; ++ibk) {
            System.out.printf(" %9.4g", xvalus[ibk - 1]);
        }
        System.out.printf("\n", new Object[0]);
        if (overpr) {
            String chmess = "   Overprint character is &";
            System.out.printf("                         ONE COLUMN=%13.7g%s", bwidx, chmess);
        } else {
            String chmess = " ";
            System.out.printf("                         ONE COLUMN=%13.7g%s", bwidx, chmess);
        }
        System.out.println();
    }

    private void mnbins(double a1, double a2, int naa) {
        boolean skip;
        double ah;
        int na = 0;
        double al = a1 < a2 ? a1 : a2;
        double d = ah = a1 > a2 ? a1 : a2;
        if (al == ah) {
            ah = al + 1.0;
        }
        boolean bl = skip = naa == -1 && this.bwid > 0.0;
        if (!skip && (na = naa - 1) < 1) {
            na = 1;
        }
        while (true) {
            if (!skip) {
                double sigrnd;
                double sigfig;
                double awid = (ah - al) / (double)na;
                int log_ = (int)Math.log10(awid);
                if (awid <= 1.0) {
                    --log_;
                }
                if ((sigfig = awid * Math.pow(10.0, -log_)) <= 2.0) {
                    sigrnd = 2.0;
                } else if (sigfig <= 2.5) {
                    sigrnd = 2.5;
                } else if (sigfig <= 5.0) {
                    sigrnd = 5.0;
                } else {
                    sigrnd = 1.0;
                    ++log_;
                }
                this.bwid = sigrnd * Math.pow(10.0, log_);
            }
            double alb = al / this.bwid;
            int lwid = (int)alb;
            if (alb < 0.0) {
                --lwid;
            }
            this.bl = this.bwid * (double)lwid;
            alb = ah / this.bwid + 1.0;
            int kwid = (int)alb;
            if (alb < 0.0) {
                --kwid;
            }
            this.bh = this.bwid * (double)kwid;
            this.nb = kwid - lwid;
            if (naa <= 5) {
                if (naa == -1) {
                    return;
                }
                if (naa > 1 || this.nb == 1) {
                    return;
                }
                this.bwid *= 2.0;
                this.nb = 1;
                return;
            }
            if (this.nb << 1 != naa) {
                return;
            }
            ++na;
            skip = false;
        }
    }
}

