/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

class MinuitParameter {
    private int theNum;
    private String theName;
    private double theValue;
    private double theError;
    private boolean theConst;
    private boolean theFix;
    private double theLoLimit;
    private double theUpLimit;
    private boolean theLoLimValid;
    private boolean theUpLimValid;

    public MinuitParameter(int num, String name, double val) {
        this.theNum = num;
        this.theValue = val;
        this.theConst = true;
        this.theName = name;
    }

    public MinuitParameter(int num, String name, double val, double err) {
        this.theNum = num;
        this.theValue = val;
        this.theError = err;
        this.theName = name;
    }

    public MinuitParameter(int num, String name, double val, double err, double min, double max) {
        this.theNum = num;
        this.theValue = val;
        this.theError = err;
        this.theLoLimit = min;
        this.theUpLimit = max;
        this.theLoLimValid = true;
        this.theUpLimValid = true;
        if (min == max) {
            throw new IllegalArgumentException("min == max");
        }
        if (min > max) {
            this.theLoLimit = max;
            this.theUpLimit = min;
        }
        this.theName = name;
    }

    protected MinuitParameter clone() {
        return new MinuitParameter(this);
    }

    private MinuitParameter(MinuitParameter other) {
        this.theNum = other.theNum;
        this.theName = other.theName;
        this.theValue = other.theValue;
        this.theError = other.theError;
        this.theConst = other.theConst;
        this.theFix = other.theFix;
        this.theLoLimit = other.theLoLimit;
        this.theUpLimit = other.theUpLimit;
        this.theLoLimValid = other.theLoLimValid;
        this.theUpLimValid = other.theUpLimValid;
    }

    public int number() {
        return this.theNum;
    }

    public String name() {
        return this.theName;
    }

    public double value() {
        return this.theValue;
    }

    public double error() {
        return this.theError;
    }

    public void setValue(double val) {
        this.theValue = val;
    }

    public void setError(double err) {
        this.theError = err;
    }

    public void setLimits(double low, double up) {
        if (low == up) {
            throw new IllegalArgumentException("min == max");
        }
        this.theLoLimit = low;
        this.theUpLimit = up;
        this.theLoLimValid = true;
        this.theUpLimValid = true;
        if (low > up) {
            this.theLoLimit = up;
            this.theUpLimit = low;
        }
    }

    public void setUpperLimit(double up) {
        this.theLoLimit = 0.0;
        this.theUpLimit = up;
        this.theLoLimValid = false;
        this.theUpLimValid = true;
    }

    public void setLowerLimit(double low) {
        this.theLoLimit = low;
        this.theUpLimit = 0.0;
        this.theLoLimValid = true;
        this.theUpLimValid = false;
    }

    public void removeLimits() {
        this.theLoLimit = 0.0;
        this.theUpLimit = 0.0;
        this.theLoLimValid = false;
        this.theUpLimValid = false;
    }

    public void fix() {
        this.theFix = true;
    }

    public void release() {
        this.theFix = false;
    }

    public boolean isConst() {
        return this.theConst;
    }

    public boolean isFixed() {
        return this.theFix;
    }

    public boolean hasLimits() {
        return this.theLoLimValid || this.theUpLimValid;
    }

    public boolean hasLowerLimit() {
        return this.theLoLimValid;
    }

    public boolean hasUpperLimit() {
        return this.theUpLimValid;
    }

    public double lowerLimit() {
        return this.theLoLimit;
    }

    public double upperLimit() {
        return this.theUpLimit;
    }
}

