/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MnAlgebraicVector;

class FunctionGradient {
    private MnAlgebraicVector theGradient;
    private MnAlgebraicVector theG2ndDerivative;
    private MnAlgebraicVector theGStepSize;
    private boolean theValid;
    private boolean theAnalytical;

    FunctionGradient(int n) {
        this.theGradient = new MnAlgebraicVector(n);
        this.theG2ndDerivative = new MnAlgebraicVector(n);
        this.theGStepSize = new MnAlgebraicVector(n);
    }

    FunctionGradient(MnAlgebraicVector grd) {
        this.theGradient = grd;
        this.theG2ndDerivative = new MnAlgebraicVector(grd.size());
        this.theGStepSize = new MnAlgebraicVector(grd.size());
        this.theValid = true;
        this.theAnalytical = true;
    }

    FunctionGradient(MnAlgebraicVector grd, MnAlgebraicVector g2, MnAlgebraicVector gstep) {
        this.theGradient = grd;
        this.theG2ndDerivative = g2;
        this.theGStepSize = gstep;
        this.theValid = true;
        this.theAnalytical = false;
    }

    MnAlgebraicVector grad() {
        return this.theGradient;
    }

    MnAlgebraicVector vec() {
        return this.theGradient;
    }

    boolean isValid() {
        return this.theValid;
    }

    boolean isAnalytical() {
        return this.theAnalytical;
    }

    MnAlgebraicVector g2() {
        return this.theG2ndDerivative;
    }

    MnAlgebraicVector gstep() {
        return this.theGStepSize;
    }
}

